/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.abc.semantics;

public class Namespace {
    private static final long PRIME_MULTIPLIER = 9929L;
    private boolean mergePrivateNamespaces = false;
    private final int kind;
    private final String name;
    private final int apiVersion;

    public Namespace(int kind) {
        this(kind, "");
    }

    public Namespace(int kind, String name) {
        this.kind = kind;
        this.apiVersion = Namespace.extractApiVersion(name);
        this.name = this.apiVersion != -1 ? Namespace.stripApiVersion(name) : name;
    }

    public int hashCode() {
        if (this.kind != 5 || this.mergePrivateNamespaces) {
            long result = this.name.hashCode();
            result = result * 9929L + (long)this.kind;
            if (this.apiVersion != -1) {
                result = result * 9929L + (long)this.apiVersion;
            }
            return (int)result;
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Namespace && this.kind != 5 || this.mergePrivateNamespaces) {
            Namespace that = (Namespace)obj;
            if (that != null) {
                return that.kind == this.kind && that.apiVersion == this.apiVersion && that.name.equals(this.name);
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return String.format("%s:\"%s\"", this.getKindString(), this.name);
    }

    public int getKind() {
        return this.kind;
    }

    private String getKindString() {
        switch (this.kind) {
            case 8: {
                return "Ns";
            }
            case 22: {
                return "PackageNs";
            }
            case 23: {
                return "PackageInternalNs";
            }
            case 24: {
                return "ProtectedNs";
            }
            case 25: {
                return "ExplicitNs";
            }
            case 26: {
                return "StaticProtectedNs";
            }
            case 5: {
                return "PrivateNs";
            }
        }
        return "Unknown(0x" + Integer.toHexString(this.kind) + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getVersionedName() {
        if (this.getApiVersion() == -1) {
            return this.name;
        }
        return this.name + new String(new int[]{this.getApiVersion() + 57344}, 0, 1);
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public static int extractApiVersion(String uri) {
        if (uri == null || uri.length() == 0) {
            return -1;
        }
        int last = uri.codePointAt(uri.length() - 1);
        if (last >= 57344 && last <= 63743) {
            return last - 57344;
        }
        return -1;
    }

    static String stripApiVersion(String uri) {
        return Namespace.extractApiVersion(uri) > 0 ? uri.substring(0, uri.length() - 1) : uri;
    }

    public void setMergePrivateNamespaces(boolean mergePrivateNamespaces) {
        assert (!mergePrivateNamespaces || this.kind != 5 || !this.name.isEmpty()) : "private namespaces must have a name when merging enabled";
        this.mergePrivateNamespaces = mergePrivateNamespaces;
    }
}

