/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jsc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.internal.codegen.mxml.flexjs.MXMLFlexJSPublisher;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDocumentNode;

public class JSCPublisher
extends MXMLFlexJSPublisher {
    private FlexJSProject project;

    public JSCPublisher(FlexJSProject project, Configuration config) {
        super(project, config);
        this.project = project;
    }

    @Override
    protected String getTemplateBody(String projectName) {
        IDefinition def = this.project.resolveQNameToDefinition(projectName);
        IDefinitionNode node = def.getNode();
        if (node instanceof IMXMLDocumentNode) {
            return super.getTemplateBody(projectName);
        }
        StringBuilder bodyHTML = new StringBuilder();
        bodyHTML.append("\t<script type=\"text/javascript\">\n");
        bodyHTML.append("\t\tnew ");
        bodyHTML.append(projectName);
        bodyHTML.append("();\n");
        bodyHTML.append("\t</script>\n");
        return bodyHTML.toString();
    }

    @Override
    protected void writeHTML(String type, String projectName, File targetDir, String deps, List<String> additionalHTML) throws IOException {
        if ("intermediate".equals(type)) {
            StringBuilder depsFile = new StringBuilder();
            depsFile.append(deps);
            depsFile.append("goog.require(\"");
            depsFile.append(projectName);
            depsFile.append("\");\n");
            this.writeFile(new File(targetDir, projectName + "-dependencies.js"), depsFile.toString(), false);
        }
    }
}

