/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.PrefixFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrefixFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        PrefixFileFilter filter = new PrefixFileFilter(list);
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.INSENSITIVE, list);
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.SENSITIVE, list);
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() {
        PrefixFileFilter filter = new PrefixFileFilter(new String[]{"test"});
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() {
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.INSENSITIVE, new String[]{"test"});
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() {
        PrefixFileFilter filter = new PrefixFileFilter(IOCase.SENSITIVE, new String[]{"test"});
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(PrefixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

