/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import org.apache.commons.numbers.arrays.UpdatingInterval;

final class BitIndexUpdatingInterval
implements UpdatingInterval {
    private static final long LONG_MASK = -1L;
    private static final int DIVIDE_BY_64 = 6;
    private final long[] data;
    private final int offset;
    private int left;
    private int right;

    BitIndexUpdatingInterval(int left, int right) {
        this.offset = left;
        this.left = left;
        this.right = right;
        this.data = new long[BitIndexUpdatingInterval.getLongIndex(right - this.offset) + 1];
    }

    private BitIndexUpdatingInterval(long[] data, int offset, int left, int right) {
        this.data = data;
        this.offset = offset;
        this.left = left;
        this.right = right;
    }

    private static int getLongIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static long getLongBit(int bitIndex) {
        return 1L << bitIndex;
    }

    void set(int bitIndex) {
        int index = bitIndex - this.offset;
        int i = BitIndexUpdatingInterval.getLongIndex(index);
        long m = BitIndexUpdatingInterval.getLongBit(index);
        int n = i;
        this.data[n] = this.data[n] | m;
    }

    private int nextIndex(int k) {
        int index = k - this.offset;
        int i = BitIndexUpdatingInterval.getLongIndex(index);
        long bits = this.data[i] & -1L << index;
        while (bits == 0L) {
            bits = this.data[++i];
        }
        return i * 64 + Long.numberOfTrailingZeros(bits) + this.offset;
    }

    private int previousIndex(int k) {
        int index = k - this.offset;
        int i = BitIndexUpdatingInterval.getLongIndex(index);
        long bits = this.data[i] & -1L >>> -(index + 1);
        while (bits == 0L) {
            bits = this.data[--i];
        }
        return (i + 1) * 64 - Long.numberOfLeadingZeros(bits) - 1 + this.offset;
    }

    @Override
    public int left() {
        return this.left;
    }

    @Override
    public int right() {
        return this.right;
    }

    @Override
    public int updateLeft(int k) {
        this.left = this.nextIndex(k);
        return this.left;
    }

    @Override
    public int updateRight(int k) {
        this.right = this.previousIndex(k);
        return this.right;
    }

    @Override
    public UpdatingInterval splitLeft(int ka, int kb) {
        int lower = this.left;
        this.left = this.nextIndex(kb + 1);
        return new BitIndexUpdatingInterval(this.data, this.offset, lower, this.previousIndex(ka - 1));
    }
}

