/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.exception;

import org.apache.commons.math4.legacy.exception.MathIllegalNumberException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;

public class NotFiniteNumberException
extends MathIllegalNumberException {
    private static final long serialVersionUID = -6100997100383932834L;

    public NotFiniteNumberException(Number wrong, Object ... args) {
        this((Localizable)LocalizedFormats.NOT_FINITE_NUMBER, wrong, args);
    }

    public NotFiniteNumberException(Localizable specific, Number wrong, Object ... args) {
        super(specific, wrong, args);
    }

    public static void check(double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw new NotFiniteNumberException(x, new Object[0]);
        }
    }

    public static void check(double[] val) {
        for (int i = 0; i < val.length; ++i) {
            double x = val[i];
            if (!Double.isInfinite(x) && !Double.isNaN(x)) continue;
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.ARRAY_ELEMENT, x, i);
        }
    }
}

