/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode.nonstiff;

import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.core.RealFieldElement;
import org.apache.commons.math4.legacy.ode.FieldEquationsMapper;
import org.apache.commons.math4.legacy.ode.FieldODEStateAndDerivative;
import org.apache.commons.math4.legacy.ode.nonstiff.EulerFieldStepInterpolator;
import org.apache.commons.math4.legacy.ode.nonstiff.RungeKuttaFieldIntegrator;

public class EulerFieldIntegrator<T extends RealFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public EulerFieldIntegrator(Field<T> field, T step) {
        super(field, "Euler", step);
    }

    @Override
    public T[] getC() {
        return (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)0);
    }

    @Override
    public T[][] getA() {
        return (RealFieldElement[][])MathArrays.buildArray(this.getField(), (int)0, (int)0);
    }

    @Override
    public T[] getB() {
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)1);
        b[0] = (RealFieldElement)this.getField().getOne();
        return b;
    }

    @Override
    protected EulerFieldStepInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new EulerFieldStepInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

