/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode.events;

import org.apache.commons.math4.core.jdkmath.JdkMath;

enum Transformer {
    UNINITIALIZED{

        @Override
        protected double transformed(double g) {
            return 0.0;
        }
    }
    ,
    PLUS{

        @Override
        protected double transformed(double g) {
            return g;
        }
    }
    ,
    MINUS{

        @Override
        protected double transformed(double g) {
            return -g;
        }
    }
    ,
    MIN{

        @Override
        protected double transformed(double g) {
            return JdkMath.min((double)-2.2250738585072014E-308, (double)JdkMath.min((double)(-g), (double)g));
        }
    }
    ,
    MAX{

        @Override
        protected double transformed(double g) {
            return JdkMath.max((double)Double.MIN_NORMAL, (double)JdkMath.max((double)(-g), (double)g));
        }
    };


    protected abstract double transformed(double var1);
}

