/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.integration.gauss;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;

public abstract class BaseRuleFactory<T extends Number> {
    private final Map<Integer, Pair<T[], T[]>> pointsAndWeights = new TreeMap<Integer, Pair<T[], T[]>>();
    private final Map<Integer, Pair<double[], double[]>> pointsAndWeightsDouble = new TreeMap<Integer, Pair<double[], double[]>>();

    public Pair<double[], double[]> getRule(int numberOfPoints) {
        if (numberOfPoints <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)numberOfPoints);
        }
        Pair<double[], double[]> cached = this.pointsAndWeightsDouble.get(numberOfPoints);
        if (cached == null) {
            Pair<T[], T[]> rule = this.getRuleInternal(numberOfPoints);
            cached = BaseRuleFactory.convertToDouble(rule);
            this.pointsAndWeightsDouble.put(numberOfPoints, cached);
        }
        return new Pair((Object)((double[])((double[])cached.getFirst()).clone()), (Object)((double[])((double[])cached.getSecond()).clone()));
    }

    protected synchronized Pair<T[], T[]> getRuleInternal(int numberOfPoints) {
        Pair<T[], T[]> rule = this.pointsAndWeights.get(numberOfPoints);
        if (rule == null) {
            this.addRule(this.computeRule(numberOfPoints));
            return this.getRuleInternal(numberOfPoints);
        }
        return rule;
    }

    protected void addRule(Pair<T[], T[]> rule) {
        if (((Number[])rule.getFirst()).length != ((Number[])rule.getSecond()).length) {
            throw new DimensionMismatchException(((Number[])rule.getFirst()).length, ((Number[])rule.getSecond()).length);
        }
        this.pointsAndWeights.put(((Number[])rule.getFirst()).length, rule);
    }

    protected abstract Pair<T[], T[]> computeRule(int var1);

    private static <T extends Number> Pair<double[], double[]> convertToDouble(Pair<T[], T[]> rule) {
        Number[] pT = (Number[])rule.getFirst();
        Number[] wT = (Number[])rule.getSecond();
        int len = pT.length;
        double[] pD = new double[len];
        double[] wD = new double[len];
        for (int i = 0; i < len; ++i) {
            pD[i] = pT[i].doubleValue();
            wD[i] = wT[i].doubleValue();
        }
        return new Pair((Object)pD, (Object)wD);
    }
}

