/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.moment;

import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.moment.FirstMoment;

public class SecondMoment
extends FirstMoment {
    protected double m2;

    public SecondMoment() {
        this.m2 = Double.NaN;
    }

    public SecondMoment(SecondMoment original) throws NullArgumentException {
        super(original);
        this.m2 = original.m2;
    }

    @Override
    public void increment(double d) {
        if (this.n < 1L) {
            this.m2 = 0.0;
            this.m1 = 0.0;
        }
        super.increment(d);
        this.m2 += ((double)this.n - 1.0) * this.dev * this.nDev;
    }

    @Override
    public void clear() {
        super.clear();
        this.m2 = Double.NaN;
    }

    @Override
    public double getResult() {
        return this.m2;
    }

    @Override
    public SecondMoment copy() {
        SecondMoment result = new SecondMoment();
        SecondMoment.copy(this, result);
        return result;
    }

    public static void copy(SecondMoment source, SecondMoment dest) throws NullArgumentException {
        NullArgumentException.check((Object)source);
        NullArgumentException.check((Object)dest);
        FirstMoment.copy(source, dest);
        dest.m2 = source.m2;
    }
}

