/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.net.URL;
import java.util.Arrays;
import org.apache.commons.math3.RetryRunner;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.ValueServer;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RetryRunner.class)
public final class ValueServerTest {
    private ValueServer vs = new ValueServer((RandomGenerator)new Well19937c(100));

    @Before
    public void setUp() {
        this.vs.setMode(0);
        URL url = this.getClass().getResource("testData.txt");
        this.vs.setValuesFileURL(url);
    }

    @Test
    public void testNextDigest() throws Exception {
        int i;
        double next = 0.0;
        double tolerance = 0.1;
        this.vs.computeDistribution();
        Assert.assertTrue((String)"empirical distribution property", (this.vs.getEmpiricalDistribution() != null ? 1 : 0) != 0);
        SummaryStatistics stats = new SummaryStatistics();
        for (i = 1; i < 1000; ++i) {
            next = this.vs.getNext();
            stats.addValue(next);
        }
        Assert.assertEquals((String)"mean", (double)5.069831575018909, (double)stats.getMean(), (double)tolerance);
        Assert.assertEquals((String)"std dev", (double)1.0173699343977738, (double)stats.getStandardDeviation(), (double)tolerance);
        this.vs.computeDistribution(500);
        stats = new SummaryStatistics();
        for (i = 1; i < 1000; ++i) {
            next = this.vs.getNext();
            stats.addValue(next);
        }
        Assert.assertEquals((String)"mean", (double)5.069831575018909, (double)stats.getMean(), (double)tolerance);
        Assert.assertEquals((String)"std dev", (double)1.0173699343977738, (double)stats.getStandardDeviation(), (double)tolerance);
    }

    @Test
    public void testFixedSeed() throws Exception {
        ValueServer valueServer = new ValueServer();
        URL url = this.getClass().getResource("testData.txt");
        valueServer.setValuesFileURL(url);
        valueServer.computeDistribution();
        this.checkFixedSeed(valueServer, 0);
        this.checkFixedSeed(valueServer, 3);
        this.checkFixedSeed(valueServer, 4);
        this.checkFixedSeed(valueServer, 2);
    }

    private void checkFixedSeed(ValueServer valueServer, int mode) throws Exception {
        int i;
        valueServer.reSeed(1000L);
        valueServer.setMode(mode);
        double[][] values = new double[2][100];
        for (i = 0; i < 100; ++i) {
            values[0][i] = valueServer.getNext();
        }
        valueServer.reSeed(1000L);
        for (i = 0; i < 100; ++i) {
            values[1][i] = valueServer.getNext();
        }
        Assert.assertTrue((boolean)Arrays.equals(values[0], values[1]));
    }

    @Test
    public void testNextDigestFail() throws Exception {
        try {
            this.vs.getNext();
            Assert.fail((String)"Expecting IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyReplayFile() throws Exception {
        try {
            URL url = this.getClass().getResource("emptyFile.txt");
            this.vs.setMode(1);
            this.vs.setValuesFileURL(url);
            this.vs.getNext();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyDigestFile() throws Exception {
        try {
            URL url = this.getClass().getResource("emptyFile.txt");
            this.vs.setMode(0);
            this.vs.setValuesFileURL(url);
            this.vs.computeDistribution();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (ZeroException zeroException) {
            // empty catch block
        }
    }

    @Test
    public void testReplay() throws Exception {
        double firstDataValue = 4.038625496201205;
        double secondDataValue = 3.6485326248346936;
        double tolerance = 1.0E-14;
        double compareValue = 0.0;
        this.vs.setMode(1);
        this.vs.resetReplayFile();
        compareValue = this.vs.getNext();
        Assert.assertEquals((double)compareValue, (double)firstDataValue, (double)tolerance);
        compareValue = this.vs.getNext();
        Assert.assertEquals((double)compareValue, (double)secondDataValue, (double)tolerance);
        for (int i = 3; i < 1001; ++i) {
            compareValue = this.vs.getNext();
        }
        compareValue = this.vs.getNext();
        Assert.assertEquals((double)compareValue, (double)firstDataValue, (double)tolerance);
        compareValue = this.vs.getNext();
        Assert.assertEquals((double)compareValue, (double)secondDataValue, (double)tolerance);
        this.vs.closeReplayFile();
        this.vs.closeReplayFile();
    }

    @Test
    public void testModes() throws Exception {
        this.vs.setMode(5);
        this.vs.setMu(0.0);
        Assert.assertEquals((String)"constant mode test", (double)this.vs.getMu(), (double)this.vs.getNext(), (double)Double.MIN_VALUE);
        this.vs.setMode(2);
        this.vs.setMu(2.0);
        double val = this.vs.getNext();
        Assert.assertTrue((val > 0.0 && val < 4.0 ? 1 : 0) != 0);
        this.vs.setSigma(1.0);
        this.vs.setMode(4);
        val = this.vs.getNext();
        Assert.assertTrue((String)"gaussian value close enough to mean", (val < this.vs.getMu() + 100.0 * this.vs.getSigma() ? 1 : 0) != 0);
        this.vs.setMode(3);
        val = this.vs.getNext();
        Assert.assertTrue((val > 0.0 ? 1 : 0) != 0);
        try {
            this.vs.setMode(1000);
            this.vs.getNext();
            Assert.fail((String)"bad mode, expecting IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFill() throws Exception {
        this.vs.setMode(5);
        this.vs.setMu(2.0);
        double[] val = new double[5];
        this.vs.fill(val);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((String)"fill test in place", (double)2.0, (double)val[i], (double)Double.MIN_VALUE);
        }
        double[] v2 = this.vs.fill(3);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((String)"fill test in place", (double)2.0, (double)v2[i], (double)Double.MIN_VALUE);
        }
    }

    @Test
    public void testProperties() throws Exception {
        this.vs.setMode(5);
        Assert.assertEquals((String)"mode test", (long)5L, (long)this.vs.getMode());
        this.vs.setValuesFileURL("http://www.apache.org");
        URL url = this.vs.getValuesFileURL();
        Assert.assertEquals((String)"valuesFileURL test", (Object)"http://www.apache.org", (Object)url.toString());
    }
}

