/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.MultivariateDifferentiableMultiStartOptimizer;
import org.apache.commons.math3.optimization.MultivariateDifferentiableOptimizer;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.SimpleValueChecker;
import org.apache.commons.math3.optimization.general.CircleScalar;
import org.apache.commons.math3.optimization.general.ConjugateGradientFormula;
import org.apache.commons.math3.optimization.general.NonLinearConjugateGradientOptimizer;
import org.apache.commons.math3.random.GaussianRandomGenerator;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.NormalizedRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.RandomVectorGenerator;
import org.apache.commons.math3.random.UncorrelatedRandomVectorGenerator;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class MultivariateDifferentiableMultiStartOptimizerTest {
    @Test
    public void testCircleFitting() {
        PointValuePair[] optima;
        CircleScalar circle = new CircleScalar();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        MultivariateDifferentiableOptimizer underlying = new MultivariateDifferentiableOptimizer(){
            private final NonLinearConjugateGradientOptimizer cg = new NonLinearConjugateGradientOptimizer(ConjugateGradientFormula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-10, 1.0E-10));

            public PointValuePair optimize(int maxEval, MultivariateDifferentiableFunction f, GoalType goalType, double[] startPoint) {
                return this.cg.optimize(maxEval, f, goalType, startPoint);
            }

            public int getMaxEvaluations() {
                return this.cg.getMaxEvaluations();
            }

            public int getEvaluations() {
                return this.cg.getEvaluations();
            }

            public ConvergenceChecker<PointValuePair> getConvergenceChecker() {
                return this.cg.getConvergenceChecker();
            }
        };
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(753289573253L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(new double[]{50.0, 50.0}, new double[]{10.0, 10.0}, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultivariateDifferentiableMultiStartOptimizer optimizer = new MultivariateDifferentiableMultiStartOptimizer(underlying, 10, (RandomVectorGenerator)generator);
        PointValuePair optimum = optimizer.optimize(200, (MultivariateFunction)circle, GoalType.MINIMIZE, new double[]{98.68, 47.345});
        Assert.assertEquals((long)200L, (long)optimizer.getMaxEvaluations());
        for (PointValuePair o : optima = optimizer.getOptima()) {
            Vector2D center = new Vector2D(o.getPointRef()[0], o.getPointRef()[1]);
            Assert.assertEquals((double)69.960161753, (double)circle.getRadius(center), (double)1.0E-8);
            Assert.assertEquals((double)96.075902096, (double)center.getX(), (double)1.0E-8);
            Assert.assertEquals((double)48.135167894, (double)center.getY(), (double)1.0E-8);
        }
        Assert.assertTrue((optimizer.getEvaluations() > 70 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 90 ? 1 : 0) != 0);
        Assert.assertEquals((double)3.1267527, (double)((Double)optimum.getValue()), (double)1.0E-8);
    }
}

