/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.RealFieldUnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;
import org.apache.commons.math3.dfp.DfpMath;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldBracketingNthOrderBrentSolverTest {
    private DfpField field;
    private Dfp absoluteAccuracy;
    private Dfp relativeAccuracy;
    private Dfp functionValueAccuracy;

    @Test(expected=NumberIsTooSmallException.class)
    public void testInsufficientOrder3() {
        new FieldBracketingNthOrderBrentSolver((RealFieldElement)this.relativeAccuracy, (RealFieldElement)this.absoluteAccuracy, (RealFieldElement)this.functionValueAccuracy, 1);
    }

    @Test
    public void testConstructorOK() {
        FieldBracketingNthOrderBrentSolver solver = new FieldBracketingNthOrderBrentSolver((RealFieldElement)this.relativeAccuracy, (RealFieldElement)this.absoluteAccuracy, (RealFieldElement)this.functionValueAccuracy, 2);
        Assert.assertEquals((long)2L, (long)solver.getMaximalOrder());
    }

    @Test
    public void testConvergenceOnFunctionAccuracy() {
        FieldBracketingNthOrderBrentSolver solver = new FieldBracketingNthOrderBrentSolver((RealFieldElement)this.relativeAccuracy, (RealFieldElement)this.absoluteAccuracy, (RealFieldElement)this.field.newDfp(1.0E-20), 20);
        RealFieldUnivariateFunction<Dfp> f = new RealFieldUnivariateFunction<Dfp>(){

            public Dfp value(Dfp x) {
                Dfp one = FieldBracketingNthOrderBrentSolverTest.this.field.getOne();
                Dfp oneHalf = one.divide(2);
                Dfp xMo = x.subtract(one);
                Dfp xMh = x.subtract(oneHalf);
                Dfp xPh = x.add(oneHalf);
                Dfp xPo = x.add(one);
                return xMo.multiply(xMh).multiply(x).multiply(xPh).multiply(xPo);
            }
        };
        Dfp result = (Dfp)solver.solve(20, (RealFieldUnivariateFunction)f, (RealFieldElement)this.field.newDfp(0.2), (RealFieldElement)this.field.newDfp(0.9), (RealFieldElement)this.field.newDfp(0.4), AllowedSolution.BELOW_SIDE);
        Assert.assertTrue((boolean)((Dfp)f.value((RealFieldElement)result)).abs().lessThan((Dfp)solver.getFunctionValueAccuracy()));
        Assert.assertTrue((boolean)((Dfp)f.value((RealFieldElement)result)).negativeOrNull());
        Assert.assertTrue((boolean)result.subtract(this.field.newDfp(0.5)).subtract((Dfp)solver.getAbsoluteAccuracy()).positiveOrNull());
        result = (Dfp)solver.solve(20, (RealFieldUnivariateFunction)f, (RealFieldElement)this.field.newDfp(-0.9), (RealFieldElement)this.field.newDfp(-0.2), (RealFieldElement)this.field.newDfp(-0.4), AllowedSolution.ABOVE_SIDE);
        Assert.assertTrue((boolean)((Dfp)f.value((RealFieldElement)result)).abs().lessThan((Dfp)solver.getFunctionValueAccuracy()));
        Assert.assertTrue((boolean)((Dfp)f.value((RealFieldElement)result)).positiveOrNull());
        Assert.assertTrue((boolean)result.add(this.field.newDfp(0.5)).subtract((Dfp)solver.getAbsoluteAccuracy()).negativeOrNull());
    }

    @Test
    public void testNeta() {
        for (AllowedSolution allowed : AllowedSolution.values()) {
            this.check(new RealFieldUnivariateFunction<Dfp>(){

                public Dfp value(Dfp x) {
                    return DfpMath.sin((Dfp)x).subtract(x.divide(2));
                }
            }, 200, -2.0, 2.0, allowed);
            this.check(new RealFieldUnivariateFunction<Dfp>(){

                public Dfp value(Dfp x) {
                    return DfpMath.pow((Dfp)x, (int)5).add(x).subtract(FieldBracketingNthOrderBrentSolverTest.this.field.newDfp(10000));
                }
            }, 200, -5.0, 10.0, allowed);
            this.check(new RealFieldUnivariateFunction<Dfp>(){

                public Dfp value(Dfp x) {
                    return x.sqrt().subtract(FieldBracketingNthOrderBrentSolverTest.this.field.getOne().divide(x)).subtract(FieldBracketingNthOrderBrentSolverTest.this.field.newDfp(3));
                }
            }, 200, 0.001, 10.0, allowed);
            this.check(new RealFieldUnivariateFunction<Dfp>(){

                public Dfp value(Dfp x) {
                    return DfpMath.exp((Dfp)x).add(x).subtract(FieldBracketingNthOrderBrentSolverTest.this.field.newDfp(20));
                }
            }, 200, -5.0, 5.0, allowed);
            this.check(new RealFieldUnivariateFunction<Dfp>(){

                public Dfp value(Dfp x) {
                    return DfpMath.log((Dfp)x).add(x.sqrt()).subtract(FieldBracketingNthOrderBrentSolverTest.this.field.newDfp(5));
                }
            }, 200, 0.001, 10.0, allowed);
            this.check(new RealFieldUnivariateFunction<Dfp>(){

                public Dfp value(Dfp x) {
                    return x.subtract(FieldBracketingNthOrderBrentSolverTest.this.field.getOne()).multiply(x).multiply(x).subtract(FieldBracketingNthOrderBrentSolverTest.this.field.getOne());
                }
            }, 200, -0.5, 1.5, allowed);
        }
    }

    private void check(RealFieldUnivariateFunction<Dfp> f, int maxEval, double min, double max, AllowedSolution allowedSolution) {
        FieldBracketingNthOrderBrentSolver solver = new FieldBracketingNthOrderBrentSolver((RealFieldElement)this.relativeAccuracy, (RealFieldElement)this.absoluteAccuracy, (RealFieldElement)this.functionValueAccuracy, 20);
        Dfp xResult = (Dfp)solver.solve(maxEval, f, (RealFieldElement)this.field.newDfp(min), (RealFieldElement)this.field.newDfp(max), allowedSolution);
        Dfp yResult = (Dfp)f.value((RealFieldElement)xResult);
        switch (allowedSolution) {
            case ANY_SIDE: {
                Assert.assertTrue((boolean)yResult.abs().lessThan(this.functionValueAccuracy.multiply(2)));
                break;
            }
            case LEFT_SIDE: {
                boolean increasing = ((Dfp)f.value((RealFieldElement)xResult)).add(this.absoluteAccuracy).greaterThan(yResult);
                Assert.assertTrue((boolean)(increasing ? yResult.negativeOrNull() : yResult.positiveOrNull()));
                break;
            }
            case RIGHT_SIDE: {
                boolean increasing = ((Dfp)f.value((RealFieldElement)xResult)).add(this.absoluteAccuracy).greaterThan(yResult);
                Assert.assertTrue((boolean)(increasing ? yResult.positiveOrNull() : yResult.negativeOrNull()));
                break;
            }
            case BELOW_SIDE: {
                Assert.assertTrue((boolean)yResult.negativeOrNull());
                break;
            }
            case ABOVE_SIDE: {
                Assert.assertTrue((boolean)yResult.positiveOrNull());
                break;
            }
            default: {
                throw new MathInternalError(null);
            }
        }
    }

    @Before
    public void setUp() {
        this.field = new DfpField(50);
        this.absoluteAccuracy = this.field.newDfp(1.0E-45);
        this.relativeAccuracy = this.field.newDfp(1.0E-45);
        this.functionValueAccuracy = this.field.newDfp(1.0E-45);
    }
}

