/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import org.apache.commons.math3.complex.RootsOfUnity;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class RootsOfUnityTest {
    @Test(expected=MathIllegalStateException.class)
    public void testMathIllegalState1() {
        RootsOfUnity roots = new RootsOfUnity();
        roots.getReal(0);
    }

    @Test(expected=MathIllegalStateException.class)
    public void testMathIllegalState2() {
        RootsOfUnity roots = new RootsOfUnity();
        roots.getImaginary(0);
    }

    @Test(expected=MathIllegalStateException.class)
    public void testMathIllegalState3() {
        RootsOfUnity roots = new RootsOfUnity();
        roots.isCounterClockWise();
    }

    @Test(expected=ZeroException.class)
    public void testZeroNumberOfRoots() {
        RootsOfUnity roots = new RootsOfUnity();
        roots.computeRoots(0);
    }

    @Test
    public void testGetNumberOfRoots() {
        RootsOfUnity roots = new RootsOfUnity();
        Assert.assertEquals((String)"", (long)0L, (long)roots.getNumberOfRoots());
        roots.computeRoots(5);
        Assert.assertEquals((String)"", (long)5L, (long)roots.getNumberOfRoots());
        roots.computeRoots(-5);
        Assert.assertEquals((String)"", (long)5L, (long)roots.getNumberOfRoots());
        roots.computeRoots(6);
        Assert.assertEquals((String)"", (long)6L, (long)roots.getNumberOfRoots());
    }

    @Test
    public void testComputeRoots() {
        RootsOfUnity roots = new RootsOfUnity();
        for (int n = -10; n < 11; ++n) {
            if (n == 0) continue;
            roots.computeRoots(n);
            this.doTestComputeRoots(roots);
            roots.computeRoots(-n);
            this.doTestComputeRoots(roots);
        }
    }

    private void doTestComputeRoots(RootsOfUnity roots) {
        int n = roots.isCounterClockWise() ? roots.getNumberOfRoots() : -roots.getNumberOfRoots();
        double tol = 10.0 * Math.ulp(1.0);
        for (int k = 0; k < n; ++k) {
            double t = Math.PI * 2 * (double)k / (double)n;
            String msg = String.format("n = %d, k = %d", n, k);
            Assert.assertEquals((String)msg, (double)FastMath.cos((double)t), (double)roots.getReal(k), (double)tol);
            Assert.assertEquals((String)msg, (double)FastMath.sin((double)t), (double)roots.getImaginary(k), (double)tol);
        }
    }
}

