/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.AbstractMap;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class PairTest
extends AbstractLangTest {
    PairTest() {
    }

    public static Stream<Class<? extends Map>> mapClassFactory() {
        return Stream.of(ConcurrentHashMap.class, ConcurrentSkipListMap.class, HashMap.class, TreeMap.class, WeakHashMap.class, LinkedHashMap.class);
    }

    @Test
    void testAccept() {
        Pair pair1 = Pair.of((Object)"A", (Object)"D");
        Pair pair2 = Pair.of((Object)"B", (Object)"C");
        HashMap map = new HashMap();
        pair1.accept(map::put);
        pair2.accept(map::put);
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
        pair1.accept(map::put);
        pair2.accept(map::put);
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
    }

    @Test
    void testApply() {
        Pair pair1 = Pair.of((Object)"A", (Object)"D");
        Pair pair2 = Pair.of((Object)"B", (Object)"C");
        HashMap map = new HashMap();
        Assertions.assertNull((Object)pair1.apply(map::put));
        Assertions.assertNull((Object)pair2.apply(map::put));
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
        Assertions.assertEquals((Object)"D", (Object)pair1.apply(map::put));
        Assertions.assertEquals((Object)"C", (Object)pair2.apply(map::put));
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
    }

    @Test
    void testComparableAllDifferent() {
        Pair pair1 = Pair.of((Object)"A", (Object)"D");
        Pair pair2 = Pair.of((Object)"B", (Object)"C");
        Assertions.assertEquals((int)0, (int)pair1.compareTo(pair1));
        Assertions.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)pair2.compareTo(pair2));
        Assertions.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testComparableLeftEquals() {
        Pair pair1 = Pair.of((Object)"E", (Object)"C");
        Pair pair2 = Pair.of((Object)"E", (Object)"D");
        Assertions.assertEquals((int)0, (int)pair1.compareTo(pair1));
        Assertions.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)pair2.compareTo(pair2));
        Assertions.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testComparableRightEquals() {
        Pair pair1 = Pair.of((Object)"A", (Object)"E");
        Pair pair2 = Pair.of((Object)"B", (Object)"E");
        Assertions.assertEquals((int)0, (int)pair1.compareTo(pair1));
        Assertions.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)pair2.compareTo(pair2));
        Assertions.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testCompatibilityBetweenPairs() {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        MutablePair pair2 = MutablePair.of((Object)0, (Object)"foo");
        Assertions.assertEquals((Object)pair, (Object)pair2);
        Assertions.assertEquals((int)pair.hashCode(), (int)pair2.hashCode());
        HashSet<ImmutablePair> set = new HashSet<ImmutablePair>();
        set.add(pair);
        Assertions.assertTrue((boolean)set.contains(pair2));
        pair2.setValue((Object)"bar");
        Assertions.assertNotEquals((Object)pair, (Object)pair2);
        Assertions.assertNotEquals((int)pair.hashCode(), (int)pair2.hashCode());
    }

    @Test
    void testEmptyArrayGenerics() {
        Pair[] empty = Pair.emptyArray();
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    void testEmptyArrayLength() {
        Pair[] empty = Pair.EMPTY_ARRAY;
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    void testEqualsAnonynous() {
        Pair pair = Pair.of((Object)"a", (Object)"b");
        String key = "a";
        String value = "b";
        Map.Entry<String, String> entry = new Map.Entry<String, String>(){

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
            }

            @Override
            public String getKey() {
                return "a";
            }

            @Override
            public String getValue() {
                return "b";
            }

            @Override
            public int hashCode() {
                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
            }

            @Override
            public String setValue(String value) {
                return null;
            }
        };
        Map.Entry<String, String> entry2 = new Map.Entry<String, String>(){

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
            }

            @Override
            public String getKey() {
                return "a";
            }

            @Override
            public String getValue() {
                return "b";
            }

            @Override
            public int hashCode() {
                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
            }

            @Override
            public String setValue(String value) {
                return null;
            }
        };
        Assertions.assertEquals((Object)pair, (Object)entry);
        Assertions.assertEquals((int)pair.hashCode(), (int)entry.hashCode());
        Assertions.assertEquals((Object)pair, (Object)entry2);
        Assertions.assertEquals((int)pair.hashCode(), (int)entry2.hashCode());
        Assertions.assertEquals((Object)entry, (Object)entry);
        Assertions.assertEquals((int)entry.hashCode(), (int)entry.hashCode());
        Assertions.assertEquals((Object)entry2, (Object)entry2);
        Assertions.assertEquals((int)entry2.hashCode(), (int)entry2.hashCode());
        Assertions.assertEquals((Object)entry, (Object)entry2);
        Assertions.assertEquals((int)entry.hashCode(), (int)entry2.hashCode());
        Assertions.assertEquals((Object)entry, (Object)pair);
        Assertions.assertEquals((int)entry.hashCode(), (int)pair.hashCode());
    }

    @Test
    void testFormattable_padded() {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assertions.assertEquals((Object)"         (Key,Value)", (Object)String.format("%1$20s", pair));
    }

    @Test
    void testFormattable_simple() {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assertions.assertEquals((Object)"(Key,Value)", (Object)String.format("%1$s", pair));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.tuple.PairTest#mapClassFactory"})
    public <K, V> void testMapEntries(Class<Map<Integer, String>> clazz) throws InstantiationException, IllegalAccessException {
        this.testMapEntry(clazz.newInstance());
    }

    public <K, V> void testMapEntries(Map<Integer, String> map) {
        this.testMapEntry(map);
    }

    private void testMapEntry(Map<Integer, String> map) {
        map.put(0, "foo");
        Map.Entry<Integer, String> entry = map.entrySet().iterator().next();
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        Assertions.assertEquals((Object)pair, entry);
        Assertions.assertEquals((int)pair.hashCode(), (int)entry.hashCode());
        map.clear();
        map.put(0, "value1");
        map.put(1, "value2");
        map.entrySet().forEach(e -> {
            ImmutablePair p = ImmutablePair.of((Object)((Integer)e.getKey()), (Object)((String)e.getValue()));
            Assertions.assertEquals((Object)p, (Object)e);
            Assertions.assertEquals((int)p.hashCode(), (int)e.hashCode());
        });
    }

    @Test
    void testOfNonNull() {
        LangAssertions.assertNullPointerException(() -> Pair.ofNonNull(null, null));
        LangAssertions.assertNullPointerException(() -> Pair.ofNonNull(null, (Object)"x"));
        LangAssertions.assertNullPointerException(() -> Pair.ofNonNull((Object)"x", null));
        Pair pair = Pair.ofNonNull((Object)"x", (Object)"y");
        Assertions.assertEquals((Object)"x", (Object)pair.getLeft());
        Assertions.assertEquals((Object)"y", (Object)pair.getRight());
    }

    @Test
    void testPairOfAbstractMapSimpleEntry() {
        AbstractMap.SimpleEntry<Integer, String> entry = new AbstractMap.SimpleEntry<Integer, String>(0, "foo");
        Pair pair = Pair.of(entry);
        Assertions.assertEquals((Integer)((Integer)entry.getKey()), (Integer)((Integer)pair.getLeft()));
        Assertions.assertEquals(entry.getValue(), (Object)pair.getRight());
        Assertions.assertEquals(entry, (Object)pair);
        Assertions.assertEquals((int)entry.hashCode(), (int)pair.hashCode());
        Assertions.assertEquals((Object)pair, entry);
        Assertions.assertEquals((int)pair.hashCode(), (int)entry.hashCode());
    }

    @Test
    void testPairOfMapEntry() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "foo");
        Map.Entry entry = map.entrySet().iterator().next();
        Pair pair = Pair.of(entry);
        Assertions.assertEquals((Integer)((Integer)entry.getKey()), (Integer)((Integer)pair.getLeft()));
        Assertions.assertEquals(entry.getValue(), (Object)pair.getRight());
    }

    @Test
    void testPairOfObjects() {
        Pair pair = Pair.of((Object)0, (Object)"foo");
        Assertions.assertInstanceOf(ImmutablePair.class, (Object)pair);
        Assertions.assertEquals((int)0, (int)((Integer)((ImmutablePair)pair).left));
        Assertions.assertEquals((Object)"foo", (Object)((ImmutablePair)pair).right);
        Pair pair2 = Pair.of(null, (Object)"bar");
        Assertions.assertInstanceOf(ImmutablePair.class, (Object)pair2);
        Assertions.assertNull((Object)((ImmutablePair)pair2).left);
        Assertions.assertEquals((Object)"bar", (Object)((ImmutablePair)pair2).right);
        Pair pair3 = Pair.of(null, null);
        Assertions.assertNull((Object)pair3.getLeft());
        Assertions.assertNull((Object)pair3.getRight());
    }

    @Test
    void testToString() {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assertions.assertEquals((Object)"(Key,Value)", (Object)pair.toString());
    }

    @Test
    void testToStringCustom() {
        Calendar date = Calendar.getInstance();
        date.set(2011, 3, 25);
        Pair pair = Pair.of((Object)"DOB", (Object)date);
        Assertions.assertEquals((Object)"Test created on 04-25-2011", (Object)pair.toString("Test created on %2$tm-%2$td-%2$tY"));
    }
}

