/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.TimeZones;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.junitpioneer.jupiter.DefaultLocale;
import org.junitpioneer.jupiter.DefaultTimeZone;
import org.junitpioneer.jupiter.ReadsDefaultLocale;
import org.junitpioneer.jupiter.ReadsDefaultTimeZone;

@DefaultLocale(language="en")
@DefaultTimeZone(value="GMT")
@ReadsDefaultLocale
@ReadsDefaultTimeZone
class FastDateParser_TimeZoneStrategyTest
extends AbstractLangTest {
    private static final List<Locale> Java11Failures = new ArrayList<Locale>();
    private static final List<Locale> Java17Failures = new ArrayList<Locale>();
    private static final AtomicInteger fails = new AtomicInteger();

    FastDateParser_TimeZoneStrategyTest() {
    }

    @AfterAll
    public static void afterAll() {
        if (!Java17Failures.isEmpty()) {
            System.err.printf("Actual failures on Java 17+: %,d%n%s%n", Java17Failures.size(), Java17Failures);
        }
        if (!Java11Failures.isEmpty()) {
            System.err.printf("Actual failures on Java 11: %,d%n%s%n", Java11Failures.size(), Java11Failures);
        }
    }

    static Set<Map.Entry<String, String>> getZoneIdStream() {
        return ZoneId.SHORT_IDS.entrySet();
    }

    private String[][] getZoneStringsSorted(Locale locale) {
        return (String[][])ArraySorter.sort((Object[])DateFormatSymbols.getInstance(locale).getZoneStrings(), Comparator.comparing(array -> array[0]));
    }

    @ParameterizedTest
    @ValueSource(strings={"ACT", "CST"})
    void testJava25DeprecatedZoneId(String shortId) throws ParseException {
        FastDateParser parser = new FastDateParser("dd.MM.yyyy HH:mm:ss z", TimeZone.getTimeZone(shortId), Locale.getDefault());
        Date date1 = parser.parse("26.10.2014 02:00:00 " + shortId);
        Assertions.assertNotNull((Object)date1);
        Assertions.assertEquals((int)2014, (int)(date1.getYear() + 1900));
    }

    @Disabled
    @ParameterizedTest
    @MethodSource(value={"getZoneIdStream"})
    void testJava25DeprecatedZoneIds(Map.Entry<String, String> entry) throws ParseException {
        FastDateParser parser = new FastDateParser("dd.MM.yyyy HH:mm:ss z", TimeZone.getDefault(), Locale.GERMAN);
        Date date1 = parser.parse("26.10.2014 02:00:00 " + entry.getKey());
        Date date2 = parser.parse("26.10.2014 02:00:00 " + entry.getValue());
        Assertions.assertNotEquals((long)date1.getTime(), (long)date2.getTime());
    }

    @Test
    void testLang1219() throws ParseException {
        FastDateParser parser = new FastDateParser("dd.MM.yyyy HH:mm:ss z", TimeZone.getDefault(), Locale.GERMAN);
        Date summer = parser.parse("26.10.2014 02:00:00 MESZ");
        Date standard = parser.parse("26.10.2014 02:00:00 MEZ");
        Assertions.assertNotEquals((long)summer.getTime(), (long)standard.getTime());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.LocaleUtils#availableLocaleList()"})
    void testTimeZoneStrategy_DateFormatSymbols(Locale locale) {
        this.testTimeZoneStrategyPattern_DateFormatSymbols_getZoneStrings(locale);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.lang3.LocaleUtils#availableLocaleList()"})
    void testTimeZoneStrategy_TimeZone(Locale locale) {
        this.testTimeZoneStrategyPattern_TimeZone_getAvailableIDs(locale);
    }

    private void testTimeZoneStrategyPattern(String languageTag, String source) throws ParseException {
        Locale locale = Locale.forLanguageTag(languageTag);
        TimeZone timeZone = TimeZones.getTimeZone((String)"Etc/UTC");
        Assumptions.assumeFalse((boolean)LocaleUtils.isLanguageUndetermined((Locale)locale), () -> this.toFailureMessage(locale, languageTag, timeZone));
        Assumptions.assumeTrue((boolean)LocaleUtils.isAvailableLocale((Locale)locale), () -> this.toFailureMessage(locale, languageTag, timeZone));
        FastDateParser parser = new FastDateParser("z", timeZone, locale);
        parser.parse(source);
        this.testTimeZoneStrategyPattern_TimeZone_getAvailableIDs(locale);
    }

    private void testTimeZoneStrategyPattern_DateFormatSymbols_getZoneStrings(Locale locale) {
        String[][] zones;
        Objects.requireNonNull(locale, "locale");
        Assumptions.assumeFalse((boolean)LocaleUtils.isLanguageUndetermined((Locale)locale), () -> this.toFailureMessage(locale, null, null));
        Assumptions.assumeTrue((boolean)LocaleUtils.isAvailableLocale((Locale)locale), () -> this.toFailureMessage(locale, null, null));
        for (String[] zone : zones = this.getZoneStringsSorted(locale)) {
            String tzDisplay;
            for (int zIndex = 1; zIndex < zone.length && (tzDisplay = zone[zIndex]) != null; ++zIndex) {
                TimeZone timeZone = TimeZone.getDefault();
                FastDateParser parser = new FastDateParser("z", timeZone, locale);
                try {
                    parser.parse(tzDisplay);
                    continue;
                }
                catch (ParseException e) {
                    String localeStr = locale.toString();
                    if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17) && (localeStr.contains("_") || "Coordinated Universal Time".equals(tzDisplay) || "sommartid \u2013 Atyrau".equals(tzDisplay))) {
                        Java17Failures.add(locale);
                        System.err.printf("[%,d][%s] Java %s %s - Mark as an assumption failure instead of a hard fail: locale = '%s', parse = '%s'%n", fails.incrementAndGet(), Thread.currentThread().getName(), SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_VM_VERSION, localeStr, tzDisplay);
                        Assumptions.assumeTrue((boolean)false, (String)localeStr);
                        continue;
                    }
                    if (SystemUtils.IS_JAVA_11 && (localeStr.contains("_") || "Coordinated Universal Time".equals(tzDisplay))) {
                        Java11Failures.add(locale);
                        System.err.printf("[%,d][%s] Java %s %s - Mark as an assumption failure instead of a hard fail: locale = '%s', parse = '%s'%n", fails.incrementAndGet(), Thread.currentThread().getName(), SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_VM_VERSION, localeStr, tzDisplay);
                        Assumptions.assumeTrue((boolean)false, (String)localeStr);
                        continue;
                    }
                    Assertions.fail((String)String.format("%s: with locale = %s, zIndex = %,d, tzDisplay = '%s', parser = '%s'", e, localeStr, zIndex, tzDisplay, parser), (Throwable)e);
                }
            }
        }
    }

    private void testTimeZoneStrategyPattern_TimeZone_getAvailableIDs(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        Assumptions.assumeFalse((boolean)LocaleUtils.isLanguageUndetermined((Locale)locale), () -> this.toFailureMessage(locale, null, null));
        Assumptions.assumeTrue((boolean)LocaleUtils.isAvailableLocale((Locale)locale), () -> this.toFailureMessage(locale, null, null));
        for (String id : (String[])ArraySorter.sort((Object[])TimeZone.getAvailableIDs())) {
            TimeZone timeZone = TimeZones.getTimeZone((String)id);
            String displayName = timeZone.getDisplayName(locale);
            FastDateParser parser = new FastDateParser("z", timeZone, locale);
            try {
                parser.parse(displayName);
            }
            catch (ParseException e) {
                Assertions.fail((String)String.format("%s: with id = '%s', displayName = '%s', %s, parser = '%s'", e, id, displayName, this.toFailureMessage(locale, null, timeZone), parser.toStringAll()), (Throwable)e);
            }
        }
    }

    @Test
    void testTimeZoneStrategyPattern_zh_HK_Hans() throws ParseException {
        this.testTimeZoneStrategyPattern("zh_HK_#Hans", "?????????");
    }

    @Test
    void testTimeZoneStrategyPatternPortugal() throws ParseException {
        this.testTimeZoneStrategyPattern("pt_PT", "Hor\u00e1rio do Meridiano de Greenwich");
    }

    @Test
    void testTimeZoneStrategyPatternSuriname() throws ParseException {
        this.testTimeZoneStrategyPattern("sr_ME_#Cyrl", "Srednje vreme po Grini\u010du");
    }

    private String toFailureMessage(Locale locale, String languageTag, TimeZone timeZone) {
        return String.format("locale = %s, languageTag = '%s', isAvailableLocale = %s, isLanguageUndetermined = %s, timeZone = %s", languageTag, locale, LocaleUtils.isAvailableLocale((Locale)locale), LocaleUtils.isLanguageUndetermined((Locale)locale), TimeZones.toTimeZone((TimeZone)timeZone));
    }
}

