/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.event.ObjectChangeListener;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.apache.commons.lang3.event.EventUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EventUtilsTest
extends AbstractLangTest {
    EventUtilsTest() {
    }

    @Test
    void testAddEventListener() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCountingInvocationHandler handler = new EventCountingInvocationHandler();
        PropertyChangeListener listener = handler.createListener(PropertyChangeListener.class);
        Assertions.assertEquals((int)0, (int)handler.getEventCount("propertyChange"));
        EventUtils.addEventListener((Object)src, PropertyChangeListener.class, (Object)listener);
        Assertions.assertEquals((int)0, (int)handler.getEventCount("propertyChange"));
        src.setProperty("newValue");
        Assertions.assertEquals((int)1, (int)handler.getEventCount("propertyChange"));
    }

    @Test
    void testAddEventListenerThrowsException() {
        ExceptionEventSource src = new ExceptionEventSource();
        Assertions.assertThrows(RuntimeException.class, () -> EventUtils.addEventListener((Object)src, PropertyChangeListener.class, e -> {}));
    }

    @Test
    void testAddEventListenerWithNoAddMethod() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCountingInvocationHandler handler = new EventCountingInvocationHandler();
        ObjectChangeListener listener = handler.createListener(ObjectChangeListener.class);
        IllegalArgumentException e = LangAssertions.assertIllegalArgumentException(() -> EventUtils.addEventListener((Object)src, ObjectChangeListener.class, (Object)listener));
        Assertions.assertEquals((Object)("Unable to add listener for class " + src.getClass().getName() + " and public add" + ObjectChangeListener.class.getSimpleName() + " method which takes a parameter of type " + ObjectChangeListener.class.getName() + "."), (Object)e.getMessage());
    }

    @Test
    void testAddEventListenerWithPrivateAddMethod() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCountingInvocationHandler handler = new EventCountingInvocationHandler();
        VetoableChangeListener listener = handler.createListener(VetoableChangeListener.class);
        IllegalArgumentException e = LangAssertions.assertIllegalArgumentException(() -> EventUtils.addEventListener((Object)src, VetoableChangeListener.class, (Object)listener));
        Assertions.assertEquals((Object)("Unable to add listener for class " + src.getClass().getName() + " and public add" + VetoableChangeListener.class.getSimpleName() + " method which takes a parameter of type " + VetoableChangeListener.class.getName() + "."), (Object)e.getMessage());
    }

    @Test
    void testBindEventsToMethod() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCounter counter = new EventCounter();
        EventUtils.bindEventsToMethod((Object)counter, (String)"eventOccurred", (Object)src, PropertyChangeListener.class, (String[])new String[0]);
        Assertions.assertEquals((int)0, (int)counter.getCount());
        src.setProperty("newValue");
        Assertions.assertEquals((int)1, (int)counter.getCount());
    }

    @Test
    void testBindEventsToMethodWithEvent() {
        PropertyChangeSource src = new PropertyChangeSource();
        EventCounterWithEvent counter = new EventCounterWithEvent();
        EventUtils.bindEventsToMethod((Object)counter, (String)"eventOccurred", (Object)src, PropertyChangeListener.class, (String[])new String[0]);
        Assertions.assertEquals((int)0, (int)counter.getCount());
        src.setProperty("newValue");
        Assertions.assertEquals((int)1, (int)counter.getCount());
    }

    @Test
    void testBindFilteredEventsToMethod() {
        MultipleEventSource src = new MultipleEventSource();
        EventCounter counter = new EventCounter();
        EventUtils.bindEventsToMethod((Object)counter, (String)"eventOccurred", (Object)src, MultipleEventListener.class, (String[])new String[]{"event1"});
        Assertions.assertEquals((int)0, (int)counter.getCount());
        ((MultipleEventListener)src.listeners.fire()).event1(new PropertyChangeEvent(new Date(), "Day", 0, 1));
        Assertions.assertEquals((int)1, (int)counter.getCount());
        ((MultipleEventListener)src.listeners.fire()).event2(new PropertyChangeEvent(new Date(), "Day", 1, 2));
        Assertions.assertEquals((int)1, (int)counter.getCount());
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new EventUtils());
        Constructor<?>[] cons = EventUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(EventUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(EventUtils.class.getModifiers()));
    }

    public static class PropertyChangeSource {
        private final EventListenerSupport<PropertyChangeListener> listeners = EventListenerSupport.create(PropertyChangeListener.class);
        private String property;

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.addListener((Object)listener);
        }

        protected void addVetoableChangeListener(VetoableChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.removeListener((Object)listener);
        }

        public void setProperty(String property) {
            String oldValue = this.property;
            this.property = property;
            ((PropertyChangeListener)this.listeners.fire()).propertyChange(new PropertyChangeEvent(this, "property", oldValue, property));
        }
    }

    private static final class EventCountingInvocationHandler
    implements InvocationHandler {
        private final Map<String, Integer> eventCounts = new TreeMap<String, Integer>();

        private EventCountingInvocationHandler() {
        }

        public <L> L createListener(Class<L> listenerType) {
            return listenerType.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{listenerType}, (InvocationHandler)this));
        }

        public int getEventCount(String eventName) {
            Integer count = this.eventCounts.get(eventName);
            return count == null ? 0 : count;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Integer count = this.eventCounts.get(method.getName());
            if (count == null) {
                this.eventCounts.put(method.getName(), 1);
            } else {
                this.eventCounts.put(method.getName(), count + 1);
            }
            return null;
        }
    }

    public static class ExceptionEventSource {
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new RuntimeException();
        }
    }

    public static class EventCounter {
        private int count;

        public void eventOccurred() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class EventCounterWithEvent {
        private int count;

        public void eventOccurred(PropertyChangeEvent e) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class MultipleEventSource {
        private final EventListenerSupport<MultipleEventListener> listeners = EventListenerSupport.create(MultipleEventListener.class);

        public void addMultipleEventListener(MultipleEventListener listener) {
            this.listeners.addListener((Object)listener);
        }
    }

    public static interface MultipleEventListener {
        public void event1(PropertyChangeEvent var1);

        public void event2(PropertyChangeEvent var1);
    }
}

