/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractJXPathTest {
    protected static List list() {
        return Collections.EMPTY_LIST;
    }

    protected static List list(Object o1) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o1);
        return list;
    }

    protected static List list(Object o1, Object o2) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o1);
        list.add(o2);
        return list;
    }

    protected static List list(Object o1, Object o2, Object o3) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        return list;
    }

    protected static List list(Object o1, Object o2, Object o3, Object o4) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        return list;
    }

    protected static List list(Object o1, Object o2, Object o3, Object o4, Object o5) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        list.add(o5);
        return list;
    }

    protected static List list(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        list.add(o5);
        list.add(o6);
        return list;
    }

    protected static List list(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        list.add(o5);
        list.add(o6);
        list.add(o7);
        return list;
    }

    protected static Set set(Object o1, Object o2) {
        HashSet<Object> list = new HashSet<Object>();
        list.add(o1);
        list.add(o2);
        return list;
    }

    protected static Set set(Object o1, Object o2, Object o3) {
        HashSet<Object> list = new HashSet<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        return list;
    }

    protected static Set set(Object o1, Object o2, Object o3, Object o4) {
        HashSet<Object> list = new HashSet<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        return list;
    }

    protected static Set set(Object o1, Object o2, Object o3, Object o4, Object o5) {
        HashSet<Object> list = new HashSet<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        list.add(o5);
        return list;
    }

    protected static Set set(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        HashSet<Object> list = new HashSet<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        list.add(o5);
        list.add(o6);
        return list;
    }

    protected static Set set(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        HashSet<Object> list = new HashSet<Object>();
        list.add(o1);
        list.add(o2);
        list.add(o3);
        list.add(o4);
        list.add(o5);
        list.add(o6);
        list.add(o7);
        return list;
    }

    protected void assertDocumentOrder(JXPathContext context, String path1, String path2, int expected) {
        NodePointer np2;
        NodePointer np1 = (NodePointer)context.getPointer(path1);
        int res = np1.compareTo((Object)(np2 = (NodePointer)context.getPointer(path2)));
        if (res < 0) {
            res = -1;
        } else if (res > 0) {
            res = 1;
        }
        Assertions.assertEquals((int)expected, (int)res, (String)("Comparing paths '" + path1 + "' and '" + path2 + "'"));
    }

    protected void assertXPathCreatePath(JXPathContext ctx, String xpath, Object expectedValue, String expectedPath) {
        Pointer pointer = ctx.createPath(xpath);
        Assertions.assertEquals((Object)expectedPath, (Object)pointer.asPath(), (String)("Creating path <" + xpath + ">"));
        Assertions.assertEquals((Object)expectedValue, (Object)pointer.getValue(), (String)("Creating path (pointer value) <" + xpath + ">"));
        Assertions.assertEquals((Object)expectedValue, (Object)ctx.getValue(pointer.asPath()), (String)("Creating path (context value) <" + xpath + ">"));
    }

    protected void assertXPathCreatePathAndSetValue(JXPathContext ctx, String xpath, Object value, String expectedPath) {
        Pointer pointer = ctx.createPathAndSetValue(xpath, value);
        Assertions.assertEquals((Object)expectedPath, (Object)pointer.asPath(), (String)("Creating path <" + xpath + ">"));
        Assertions.assertEquals((Object)value, (Object)pointer.getValue(), (String)("Creating path (pointer value) <" + xpath + ">"));
        Assertions.assertEquals((Object)value, (Object)ctx.getValue(pointer.asPath()), (String)("Creating path (context value) <" + xpath + ">"));
    }

    protected void assertXPathNodeType(JXPathContext ctx, String xpath, Class clazz) {
        ctx.setLenient(false);
        Pointer actual = ctx.getPointer(xpath);
        Assertions.assertTrue((boolean)clazz.isAssignableFrom(actual.getNode().getClass()), (String)("Evaluating <" + xpath + "> = " + actual.getNode().getClass()));
    }

    protected void assertXPathPointer(JXPathContext ctx, String xpath, String expected) {
        ctx.setLenient(false);
        Pointer pointer = ctx.getPointer(xpath);
        String actual = pointer.toString();
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Evaluating pointer <" + xpath + ">"));
    }

    protected void assertXPathPointerIterator(JXPathContext ctx, String xpath, Collection expected) {
        AbstractCollection actual = expected instanceof List ? new ArrayList() : new HashSet();
        Iterator it = ctx.iteratePointers(xpath);
        while (it.hasNext()) {
            Pointer pointer = (Pointer)it.next();
            actual.add(pointer.toString());
        }
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Evaluating pointer iterator <" + xpath + ">"));
    }

    protected void assertXPathPointerLenient(JXPathContext ctx, String xpath, String expected) {
        ctx.setLenient(true);
        Pointer pointer = ctx.getPointer(xpath);
        String actual = pointer.toString();
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Evaluating pointer <" + xpath + ">"));
    }

    protected void assertXPathSetValue(JXPathContext ctx, String xpath, Object value) {
        this.assertXPathSetValue(ctx, xpath, value, value);
    }

    protected void assertXPathSetValue(JXPathContext ctx, String xpath, Object value, Object expected) {
        ctx.setValue(xpath, value);
        Object actual = ctx.getValue(xpath);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Modifying <" + xpath + ">"));
    }

    protected void assertXPathValue(JXPathContext ctx, String xpath, Object expected) {
        ctx.setLenient(false);
        Object actual = ctx.getValue(xpath);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Evaluating <" + xpath + ">"));
    }

    protected void assertXPathValue(JXPathContext ctx, String xpath, Object expected, Class resultType) {
        ctx.setLenient(false);
        Object actual = ctx.getValue(xpath, resultType);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Evaluating <" + xpath + ">"));
    }

    protected void assertXPathValueAndPointer(JXPathContext ctx, String xpath, Object expectedValue, String expectedPointer) {
        this.assertXPathValue(ctx, xpath, expectedValue);
        this.assertXPathPointer(ctx, xpath, expectedPointer);
    }

    protected <E> void assertXPathValueIterator(JXPathContext ctx, String xpath, Collection<E> expected) {
        AbstractCollection actual = expected instanceof List ? new ArrayList() : new HashSet();
        Iterator it = ctx.iterate(xpath);
        while (it.hasNext()) {
            actual.add(it.next());
        }
        Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode(), (String)String.format("[hashCode()] Evaluating value iterator <%s>, expected.class %s(%,d): %s, actual.class %s(%,d): %s", xpath, expected.getClass(), expected.size(), expected, actual.getClass(), actual.size(), actual));
        Assertions.assertEquals(expected, (Object)actual, (String)String.format("[equals()] Evaluating value iterator <%s>, expected.class %s(%,d): %s, actual.class %s(%,d): %s", xpath, expected.getClass(), expected.size(), expected, actual.getClass(), actual.size(), actual));
    }

    protected void assertXPathValueLenient(JXPathContext ctx, String xpath, Object expected) {
        ctx.setLenient(true);
        Object actual = ctx.getValue(xpath);
        ctx.setLenient(false);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Evaluating lenient <" + xpath + ">"));
    }

    protected void assertXPathValueType(JXPathContext ctx, String xpath, Class clazz) {
        ctx.setLenient(false);
        Object actual = ctx.getValue(xpath);
        Assertions.assertTrue((boolean)clazz.isAssignableFrom(actual.getClass()), (String)("Evaluating <" + xpath + "> = " + actual.getClass()));
    }

    @BeforeEach
    protected void setUp() throws Exception {
        Locale.setDefault(Locale.US);
    }
}

