/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.util.HashMap;
import org.apache.commons.jxpath.util.BasicTypeConverter;
import org.apache.commons.jxpath.util.TypeConverter;

public class TypeUtils {
    private static TypeConverter typeConverter = new BasicTypeConverter();
    private static final HashMap<Class, Class> PRIMITIVE_TYPE_MAP = new HashMap();

    public static boolean canConvert(Object object, Class toType) {
        return typeConverter.canConvert(object, toType);
    }

    public static Object convert(Object object, Class toType) {
        return typeConverter.convert(object, toType);
    }

    public static TypeConverter getTypeConverter() {
        return typeConverter;
    }

    public static synchronized void setTypeConverter(TypeConverter converter) {
        typeConverter = converter;
    }

    public static Class wrapPrimitive(Class p) {
        return p.isPrimitive() ? PRIMITIVE_TYPE_MAP.get(p) : p;
    }

    @Deprecated
    public TypeUtils() {
    }

    static {
        PRIMITIVE_TYPE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TYPE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TYPE_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_TYPE_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_TYPE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_TYPE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_TYPE_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_TYPE_MAP.put(Boolean.TYPE, Boolean.class);
    }
}

