/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.HashMap;
import org.apache.commons.jexl3.ConcurrentCache;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlCache;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.MetaCache;
import org.apache.commons.jexl3.internal.Source;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SourceCacheTest {
    @Test
    void testSource() {
        JexlFeatures features = JexlFeatures.createDefault();
        Source src0 = new Source(features, null, "x -> -x");
        Source src0b = new Source(features, null, "x -> -x");
        Source src1 = new Source(features, null, "x -> +x");
        Assertions.assertEquals((int)7, (int)src0.length());
        Assertions.assertEquals((Object)src0, (Object)src0b);
        Assertions.assertNotEquals((Object)src0, (Object)src1);
        Assertions.assertEquals((int)src0.hashCode(), (int)src0b.hashCode());
        Assertions.assertNotEquals((int)src0.hashCode(), (int)src1.hashCode());
        Assertions.assertEquals((int)0, (int)src0.compareTo(src0b));
        Assertions.assertTrue((src0.compareTo(src1) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((src1.compareTo(src0) < 0 ? 1 : 0) != 0);
    }

    @Test
    void testSourceCache() {
        JexlFeatures features = JexlFeatures.createDefault();
        HashMap<String, Integer> symbols0 = new HashMap<String, Integer>();
        symbols0.put("x", 0);
        symbols0.put("y", 1);
        Source src0 = new Source(features, symbols0, "x + y");
        Assertions.assertFalse((boolean)src0.equals(null));
        Assertions.assertFalse((boolean)src0.equals((Object)"x + y"));
        HashMap symbols1 = new HashMap();
        symbols0.put("x", 0);
        symbols0.put("y", 2);
        Source src1 = new Source(features, symbols1, "x + y");
        Assertions.assertNotEquals((Object)src0, (Object)src1);
        Assertions.assertNotEquals((int)0, (int)src0.compareTo(src1));
        Source src2 = new Source(features, null, "x + y");
        Assertions.assertNotEquals((Object)src0, (Object)src2);
        Assertions.assertNotEquals((int)0, (int)src0.compareTo(src2));
        Source src3 = new Source(JexlFeatures.createNone(), symbols1, "x + y");
        Assertions.assertNotEquals((Object)src0, (Object)src3);
        Assertions.assertNotEquals((int)0, (int)src0.compareTo(src3));
        JexlEngine jexl = new JexlBuilder().cache(4).create();
        JexlCache cache = ((Engine)jexl).getCache();
        JexlScript script0 = jexl.createScript("x + y", new String[]{"x", "y"});
        Assertions.assertNotNull((Object)script0);
        JexlScript script1 = jexl.createScript("x + y", new String[]{"y", "x"});
        Assertions.assertNotNull((Object)script1);
        Assertions.assertEquals((int)2, (int)cache.size());
        cache.clear();
        script0 = jexl.createScript("x + y", new String[]{"x", "y"});
        Assertions.assertNotNull((Object)script0);
        script1 = jexl.createScript("x + y", new String[]{"x", "y"});
        Assertions.assertNotNull((Object)script1);
        Assertions.assertEquals((int)1, (int)cache.size());
    }

    @Test
    void testInterpolationCache() {
        JexlEngine jexl = new JexlBuilder().strictInterpolation(true).cache(4).create();
        JexlCache cache = ((Engine)jexl).getCache();
        for (int i = 0; i < 2; ++i) {
            JexlScript script0 = jexl.createScript("`${x}` + `${x}`", new String[]{"x"});
            Assertions.assertNotNull((Object)script0);
            Object result = script0.execute(null, new Object[]{42});
            Assertions.assertEquals((Object)"4242", (Object)result);
            Assertions.assertEquals((int)2, (int)cache.size());
        }
    }

    @Test
    void testMetaCache() {
        MetaCache mc = new MetaCache(ConcurrentCache::new);
        JexlCache cache1 = mc.createCache(3);
        cache1.put((Object)1, (Object)"one");
        cache1.put((Object)2, (Object)"two");
        cache1.put((Object)3, (Object)"three");
        Assertions.assertEquals((int)3, (int)cache1.size());
        Assertions.assertEquals((Object)"one", (Object)cache1.get((Object)1));
        Assertions.assertEquals((Object)"two", (Object)cache1.get((Object)2));
        Assertions.assertEquals((Object)"three", (Object)cache1.get((Object)3));
        cache1.put((Object)4, (Object)"four");
        Assertions.assertEquals((int)3, (int)cache1.size());
        Assertions.assertNull((Object)cache1.get((Object)1));
        Assertions.assertEquals((Object)"two", (Object)cache1.get((Object)2));
        Assertions.assertEquals((Object)"three", (Object)cache1.get((Object)3));
        Assertions.assertEquals((Object)"four", (Object)cache1.get((Object)4));
        JexlCache cache2 = mc.createCache(2);
        cache2.put((Object)"a", (Object)"A");
        cache2.put((Object)"b", (Object)"B");
        Assertions.assertEquals((int)2, (int)cache2.size());
        Assertions.assertEquals((Object)"A", (Object)cache2.get((Object)"a"));
        Assertions.assertEquals((Object)"B", (Object)cache2.get((Object)"b"));
        cache2.put((Object)"c", (Object)"C");
        Assertions.assertEquals((int)2, (int)cache2.size());
        Assertions.assertNull((Object)cache2.get((Object)"a"));
        Assertions.assertEquals((Object)"B", (Object)cache2.get((Object)"b"));
        Assertions.assertEquals((Object)"C", (Object)cache2.get((Object)"c"));
        Assertions.assertEquals((int)2, (int)mc.size());
        cache1 = null;
        Assertions.assertNull((Object)cache1);
        cache2 = null;
        Assertions.assertNull((Object)cache2);
        System.gc();
        for (int i = 0; i < 5 && mc.size() != 0; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assertions.assertEquals((int)0, (int)mc.size(), (String)"metacache should have no more cache references");
    }
}

