/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.jexl342;

import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.jexl342.ReferenceUberspect;

public class ReferenceGetExecutor
implements JexlPropertyGet {
    private final ReferenceUberspect.ReferenceHandler handler;
    private final JexlPropertyGet getter;

    public ReferenceGetExecutor(ReferenceUberspect.ReferenceHandler referenceHandler, JexlPropertyGet jexlGet) {
        if (referenceHandler == null || jexlGet == null) {
            throw new IllegalArgumentException("handler and getter cant be null");
        }
        this.handler = referenceHandler;
        this.getter = jexlGet;
    }

    protected Object getReference(Object ref) {
        return this.handler.callGet(ref);
    }

    public Object invoke(Object ref) throws Exception {
        Object obj = this.getReference(ref);
        return this.getter.invoke(obj);
    }

    public Object tryInvoke(Object ref, Object key) {
        Object obj = this.getReference(ref);
        return obj == ref ? JexlEngine.TRY_FAILED : this.getter.tryInvoke(obj, key);
    }

    public boolean tryFailed(Object rval) {
        return this.getter.tryFailed(rval);
    }

    public boolean isCacheable() {
        return this.getter.isCacheable();
    }
}

