/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.apache.commons.jexl2.ClassCreator;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassCreatorTest
extends JexlTestCase {
    static final Log logger = LogFactory.getLog(JexlTestCase.class);
    static final int LOOPS = 8;
    private File base = null;
    private JexlEngine jexl = null;
    static final int MEGA = 0x100000;

    public void setUp() throws Exception {
        this.base = new File(System.getProperty("java.io.tmpdir") + File.pathSeparator + "jexl" + System.currentTimeMillis());
        this.jexl = new JexlEngine();
        this.jexl.setCache(512);
    }

    public void tearDown() throws Exception {
        this.deleteDirectory(this.base);
    }

    private void deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        dir.delete();
    }

    public void testOne() throws Exception {
        if (!ClassCreator.canRun) {
            return;
        }
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        cctor.setSeed(1);
        Class<?> foo1 = cctor.createClass();
        ClassCreatorTest.assertEquals((String)"foo1", (String)foo1.getSimpleName());
        cctor.clear();
    }

    public void testMany() throws Exception {
        if (!ClassCreator.canRun) {
            return;
        }
        int pass = 0;
        int gced = -1;
        ReferenceQueue<Object> queue = new ReferenceQueue<Object>();
        ArrayList<Reference> stuff = new ArrayList<Reference>();
        Expression expr = this.jexl.createExpression("foo.value");
        Expression newx = this.jexl.createExpression("foo = new(clazz)");
        MapContext context = new MapContext();
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        for (int i = 0; i < 8 && gced < 0; ++i) {
            Class<?> clazz;
            cctor.setSeed(i);
            if (pass == 0) {
                clazz = cctor.createClass();
            } else {
                clazz = cctor.getClassInstance();
                if (clazz == null) {
                    ClassCreatorTest.assertEquals((int)i, (int)gced);
                    break;
                }
            }
            context.set("clazz", (Object)cctor.getClassName());
            context.set("foo", null);
            Object z = newx.evaluate((JexlContext)context);
            ClassCreatorTest.assertNull((Object)z);
            context.set("clazz", clazz);
            z = newx.evaluate((JexlContext)context);
            ClassCreatorTest.assertNotNull((String)(clazz + ": class " + i + " could not be instantiated on pass " + pass), (Object)z);
            ClassCreatorTest.assertEquals((Object)new Integer(i), (Object)expr.evaluate((JexlContext)context));
            this.jexl.setClassLoader(cctor.getClassLoader());
            z = newx.evaluate((JexlContext)context);
            ClassCreatorTest.assertTrue((boolean)z.getClass().equals(clazz));
            ClassCreatorTest.assertEquals((Object)new Integer(i), (Object)expr.evaluate((JexlContext)context));
            cctor.clear();
            this.jexl.setClassLoader(null);
            if (pass != 0) continue;
            stuff.add(new ClassReference(clazz, queue));
            stuff.add(new InstanceReference(clazz.newInstance(), queue));
            for (int b = 0; b < 64 && Runtime.getRuntime().freeMemory() > 0x100000L; ++b) {
                BigObject big = new BigObject(b);
                stuff.add(new InstanceReference(big, queue));
            }
            System.gc();
            boolean qr = false;
            while (queue.poll() != null) {
                Reference<Object> ref = queue.remove(1L);
                if (!(ref instanceof ClassReference)) continue;
                gced = i;
                qr = true;
            }
            if (!qr) continue;
            pass = 1;
            i = 0;
        }
        if (gced < 0) {
            logger.warn((Object)"unable to force GC");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class InstanceReference
    extends SoftReference<Object> {
        InstanceReference(Object obj, ReferenceQueue<Object> queue) {
            super(obj, queue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClassReference
    extends WeakReference<Class<?>> {
        ClassReference(Class<?> clazz, ReferenceQueue<Object> queue) {
            super(clazz, queue);
        }
    }

    public class BigObject {
        private final byte[] space = new byte[0x100000];
        private final int id;

        public BigObject(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

