/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class AvailableTag
extends TagSupport {
    private File file;
    private String uri;

    public void doTag(XMLOutput output) throws JellyTagException {
        boolean available = false;
        if (this.file != null) {
            available = this.file.exists();
        } else if (this.uri != null) {
            try {
                URL url = this.context.getResource(this.uri);
                String fileName = url.getFile();
                InputStream is = url.openStream();
                available = is != null;
                is.close();
            }
            catch (MalformedURLException e) {
                throw new JellyTagException((Throwable)e);
            }
            catch (IOException ioe) {
                available = false;
            }
        }
        if (available) {
            this.invokeBody(output);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getUri() {
        return this.uri;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

