/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.expr.Predicate;
import org.jaxen.function.BooleanFunction;

public class PredicateSet
implements Serializable {
    private List predicates = Collections.EMPTY_LIST;

    public void addPredicate(Predicate predicate) {
        if (this.predicates == Collections.EMPTY_LIST) {
            this.predicates = new ArrayList();
        }
        this.predicates.add(predicate);
    }

    public List getPredicates() {
        return this.predicates;
    }

    public void simplify() {
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            eachPred.simplify();
        }
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            buf.append(eachPred.getText());
        }
        return buf.toString();
    }

    protected boolean evaluateAsBoolean(List contextNodeSet, ContextSupport support) throws JaxenException {
        List result = this.evaluatePredicates(contextNodeSet, support);
        return !result.isEmpty();
    }

    protected List evaluatePredicates(List contextNodeSet, ContextSupport support) throws JaxenException {
        if (this.predicates.size() == 0) {
            return contextNodeSet;
        }
        Iterator predIter = this.predicates.iterator();
        List nodes2Filter = contextNodeSet;
        while (predIter.hasNext()) {
            nodes2Filter = this.applyPredicate((Predicate)predIter.next(), nodes2Filter, support);
        }
        return nodes2Filter;
    }

    public List applyPredicate(Predicate predicate, List nodes2Filter, ContextSupport support) throws JaxenException {
        ArrayList filteredNodes = new ArrayList();
        int nodes2FilerSize = nodes2Filter.size();
        Context predContext = new Context(support);
        ArrayList tempList = new ArrayList(1);
        predContext.setNodeSet(tempList);
        int i = 0;
        while (i < nodes2FilerSize) {
            Object contextNode = nodes2Filter.get(i);
            tempList.clear();
            tempList.add(contextNode);
            predContext.setNodeSet(tempList);
            predContext.setPosition(i + 1);
            predContext.setSize(nodes2FilerSize);
            Object predResult = predicate.evaluate(predContext);
            if (predResult instanceof Number) {
                int proximity = ((Number)predResult).intValue();
                if (proximity == i + 1) {
                    filteredNodes.add(contextNode);
                }
            } else {
                Boolean includes = BooleanFunction.evaluate(predResult, predContext.getNavigator());
                if (includes.booleanValue()) {
                    filteredNodes.add(contextNode);
                }
            }
            ++i;
        }
        return filteredNodes;
    }
}

