/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.swing;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.jelly.DynaBeanTagSupport;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.tags.swing.BeanFactory;
import org.apache.commons.jelly.tags.swing.Factory;
import org.xml.sax.Attributes;

public class ConstraintTag
extends DynaBeanTagSupport {
    protected Factory factory;
    protected String var = null;
    protected Object bean = null;

    public ConstraintTag(Factory factory) {
        this.factory = factory;
    }

    protected void createBean(Factory factory) throws InstantiationException {
        this.bean = factory.newInstance();
    }

    public void beforeSetAttributes() throws JellyTagException {
        try {
            this.createBean(this.factory);
        }
        catch (InstantiationException e) {
            throw new JellyTagException(e.toString());
        }
    }

    public void setAttribute(String name, Object value) throws JellyTagException {
        if ("var".equals(name)) {
            this.var = value.toString();
        } else {
            try {
                BeanUtils.setProperty((Object)this.bean, (String)name, (Object)value);
            }
            catch (IllegalAccessException e) {
                throw new JellyTagException(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new JellyTagException(e.toString());
            }
        }
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        if (this.var != null) {
            ((TagSupport)this).context.setVariable(this.var, this.getBean());
        }
        this.invokeBody(output);
    }

    public Object getBean() {
        return this.bean;
    }

    public Object getConstraintObject() {
        return this.getBean();
    }

    public static class ConstantFactory
    implements TagFactory,
    Factory {
        private Object constant;

        public ConstantFactory(Object c) {
            this.constant = c;
        }

        public Object newInstance() {
            return this.constant;
        }

        public Tag createTag(String name, Attributes attributes) throws JellyException {
            return new ConstraintTag(this);
        }
    }

    public static class HereFactory
    extends BeanFactory
    implements TagFactory {
        public HereFactory(Class c) {
            super(c);
        }

        public Tag createTag(String name, Attributes attributes) {
            return new ConstraintTag(this);
        }
    }
}

