/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.admin;

import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.admin.CacheElementInfo;
import org.apache.commons.jcs3.admin.CacheRegionInfo;
import org.apache.commons.jcs3.admin.JCSAdminBean;

public class AdminBeanUnitTest
extends TestCase {
    public void testGetRegionInfo() throws Exception {
        String regionName = "myRegion";
        CacheAccess cache = JCS.getInstance((String)"myRegion");
        cache.put((Object)"key", (Object)"value");
        JCSAdminBean admin = new JCSAdminBean();
        List regions = admin.buildCacheInfo();
        boolean foundRegion = false;
        for (CacheRegionInfo info : regions) {
            if (!info.getCacheName().equals("myRegion")) continue;
            foundRegion = true;
            AdminBeanUnitTest.assertTrue((String)"Byte count should be greater than 5.", (info.getByteCount() > 5L ? 1 : 0) != 0);
            AdminBeanUnitTest.assertNotNull((String)"Should have stats.", (Object)info.getCacheStatistics());
        }
        AdminBeanUnitTest.assertTrue((String)"Should have found the region we just created.", (boolean)foundRegion);
    }

    public void testGetElementForRegionInfo() throws Exception {
        String regionName = "myRegion";
        CacheAccess cache = JCS.getInstance((String)"myRegion");
        cache.clear();
        String key = "myKey";
        cache.put((Object)"myKey", (Object)"value");
        JCSAdminBean admin = new JCSAdminBean();
        List elements = admin.buildElementInfo("myRegion");
        AdminBeanUnitTest.assertEquals((String)"Wrong number of elements in the region.", (int)1, (int)elements.size());
        CacheElementInfo elementInfo = (CacheElementInfo)elements.get(0);
        AdminBeanUnitTest.assertEquals((String)("Wrong key." + elementInfo), (String)"myKey", (String)elementInfo.getKey());
    }

    public void testRemove() throws Exception {
        JCSAdminBean admin = new JCSAdminBean();
        String regionName = "myRegion";
        CacheAccess cache = JCS.getInstance((String)"myRegion");
        cache.clear();
        admin.clearRegion("myRegion");
        String key = "myKey";
        cache.put((Object)"myKey", (Object)"value");
        List elements = admin.buildElementInfo("myRegion");
        AdminBeanUnitTest.assertEquals((String)"Wrong number of elements in the region.", (int)1, (int)elements.size());
        CacheElementInfo elementInfo = (CacheElementInfo)elements.get(0);
        AdminBeanUnitTest.assertEquals((String)"Wrong key.", (String)"myKey", (String)elementInfo.getKey());
        admin.removeItem("myRegion", "myKey");
        List elements2 = admin.buildElementInfo("myRegion");
        AdminBeanUnitTest.assertEquals((String)"Wrong number of elements in the region after remove.", (int)0, (int)elements2.size());
    }

    public void testClearAll() throws Exception {
        JCSAdminBean admin = new JCSAdminBean();
        String regionName = "myRegion";
        CacheAccess cache = JCS.getInstance((String)"myRegion");
        String key = "myKey";
        cache.put((Object)"myKey", (Object)"value");
        admin.clearAllRegions();
        List elements2 = admin.buildElementInfo("myRegion");
        AdminBeanUnitTest.assertEquals((String)"Wrong number of elements in the region after remove.", (int)0, (int)elements2.size());
    }
}

