/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.itu_t4.T4AndT6Compression;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffCcittTest
extends AbstractTiffTest {
    private static boolean nextCombination(int[] sequence, int max) {
        int i;
        for (i = 0; i < sequence.length; ++i) {
            if (sequence[i] != max) {
                int n = i;
                sequence[n] = sequence[n] + 1;
                break;
            }
            sequence[i] = 0;
        }
        return i < sequence.length;
    }

    private void compareImages(BufferedImage a, BufferedImage b) {
        Assertions.assertEquals((int)a.getWidth(), (int)b.getWidth());
        Assertions.assertEquals((int)a.getHeight(), (int)b.getHeight());
        for (int x = 0; x < a.getWidth(); ++x) {
            for (int y = 0; y < a.getHeight(); ++y) {
                int bArgb;
                int aArgb = a.getRGB(x, y);
                if (aArgb != (bArgb = b.getRGB(x, y))) {
                    Debug.debug((String)("width: " + a.getWidth()));
                    Debug.debug((String)("height: " + a.getHeight()));
                    Debug.debug((String)("x: " + x));
                    Debug.debug((String)("y: " + y));
                    Debug.debug((String)("aArgb: " + aArgb + " (0x" + Integer.toHexString(aArgb) + ")"));
                    Debug.debug((String)("bArgb: " + bArgb + " (0x" + Integer.toHexString(bArgb) + ")"));
                }
                Assertions.assertEquals((int)aArgb, (int)bArgb);
            }
        }
    }

    @Test
    public void testAll5x2Compressions() {
        byte[] uncompressed = new byte[2];
        int[] combinations = new int[10];
        do {
            int i;
            byte[] result;
            byte[] compressed;
            int x;
            for (x = 0; x < 5; ++x) {
                if (combinations[x] == 0) continue;
                uncompressed[0] = (byte)(uncompressed[0] | 128 >>> x);
            }
            for (x = 0; x < 5; ++x) {
                if (combinations[5 + x] == 0) continue;
                uncompressed[1] = (byte)(uncompressed[1] | 128 >>> x);
            }
            try {
                compressed = T4AndT6Compression.compressModifiedHuffman((byte[])uncompressed, (int)5, (int)2);
                result = T4AndT6Compression.decompressModifiedHuffman((byte[])compressed, (int)5, (int)2);
                Assertions.assertEquals((int)uncompressed.length, (int)result.length);
                for (i = 0; i < uncompressed.length; ++i) {
                    Assertions.assertEquals((byte)uncompressed[i], (byte)result[i]);
                }
            }
            catch (ImagingException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                compressed = T4AndT6Compression.compressT4_1D((byte[])uncompressed, (int)5, (int)2, (boolean)true);
                result = T4AndT6Compression.decompressT4_1D((byte[])compressed, (int)5, (int)2, (boolean)true);
                Assertions.assertEquals((int)uncompressed.length, (int)result.length);
                for (i = 0; i < uncompressed.length; ++i) {
                    Assertions.assertEquals((byte)uncompressed[i], (byte)result[i]);
                }
            }
            catch (ImagingException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                compressed = T4AndT6Compression.compressT4_1D((byte[])uncompressed, (int)5, (int)2, (boolean)false);
                result = T4AndT6Compression.decompressT4_1D((byte[])compressed, (int)5, (int)2, (boolean)false);
                Assertions.assertEquals((int)uncompressed.length, (int)result.length);
                for (i = 0; i < uncompressed.length; ++i) {
                    Assertions.assertEquals((byte)uncompressed[i], (byte)result[i]);
                }
            }
            catch (ImagingException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                compressed = T4AndT6Compression.compressT4_2D((byte[])uncompressed, (int)5, (int)2, (boolean)true, (int)2);
                result = T4AndT6Compression.decompressT4_2D((byte[])compressed, (int)5, (int)2, (boolean)true);
                Assertions.assertEquals((int)uncompressed.length, (int)result.length);
                for (i = 0; i < uncompressed.length; ++i) {
                    Assertions.assertEquals((byte)uncompressed[i], (byte)result[i]);
                }
            }
            catch (ImagingException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                compressed = T4AndT6Compression.compressT4_2D((byte[])uncompressed, (int)5, (int)2, (boolean)false, (int)2);
                result = T4AndT6Compression.decompressT4_2D((byte[])compressed, (int)5, (int)2, (boolean)false);
                Assertions.assertEquals((int)uncompressed.length, (int)result.length);
                for (i = 0; i < uncompressed.length; ++i) {
                    Assertions.assertEquals((byte)uncompressed[i], (byte)result[i]);
                }
            }
            catch (ImagingException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                compressed = T4AndT6Compression.compressT6((byte[])uncompressed, (int)5, (int)2);
                result = T4AndT6Compression.decompressT6((byte[])compressed, (int)5, (int)2);
                Assertions.assertEquals((int)uncompressed.length, (int)result.length);
                for (i = 0; i < uncompressed.length; ++i) {
                    Assertions.assertEquals((byte)uncompressed[i], (byte)result[i]);
                }
            }
            catch (ImagingException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
        } while (TiffCcittTest.nextCombination(combinations, 1));
    }

    @Test
    public void testAll5x2Images() {
        int[] combinations = new int[10];
        BufferedImage image = new BufferedImage(5, 2, 1);
        do {
            TiffImagingParameters params;
            BufferedImage result;
            byte[] compressed;
            ByteArrayOutputStream baos;
            int x;
            for (x = 0; x < 5; ++x) {
                if (combinations[x] == 0) {
                    image.setRGB(x, 0, 0xFFFFFF);
                    continue;
                }
                image.setRGB(x, 0, 0);
            }
            for (x = 0; x < 5; ++x) {
                if (combinations[5 + x] == 0) {
                    image.setRGB(x, 1, 0xFFFFFF);
                    continue;
                }
                image.setRGB(x, 1, 0);
            }
            try {
                TiffImagingParameters params2 = new TiffImagingParameters();
                params2.setCompression(Integer.valueOf(2));
                TiffImageParser tiffImageParser = new TiffImageParser();
                baos = new ByteArrayOutputStream();
                try {
                    tiffImageParser.writeImage(image, (OutputStream)baos, params2);
                    compressed = baos.toByteArray();
                }
                finally {
                    baos.close();
                }
                result = Imaging.getBufferedImage((byte[])compressed);
                this.compareImages(image, result);
            }
            catch (IOException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            TiffImageParser tiffImageParser = new TiffImageParser();
            try {
                params = new TiffImagingParameters();
                params.setCompression(Integer.valueOf(3));
                params.setT4Options(Integer.valueOf(0));
                baos = new ByteArrayOutputStream();
                try {
                    tiffImageParser.writeImage(image, (OutputStream)baos, params);
                    compressed = baos.toByteArray();
                }
                finally {
                    baos.close();
                }
                result = Imaging.getBufferedImage((byte[])compressed);
                this.compareImages(image, result);
            }
            catch (IOException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                params = new TiffImagingParameters();
                params.setCompression(Integer.valueOf(3));
                params.setT4Options(Integer.valueOf(4));
                baos = new ByteArrayOutputStream();
                try {
                    tiffImageParser.writeImage(image, (OutputStream)baos, params);
                    compressed = baos.toByteArray();
                }
                finally {
                    baos.close();
                }
                result = Imaging.getBufferedImage((byte[])compressed);
                this.compareImages(image, result);
            }
            catch (IOException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                params = new TiffImagingParameters();
                params.setCompression(Integer.valueOf(3));
                params.setT4Options(Integer.valueOf(1));
                baos = new ByteArrayOutputStream();
                try {
                    tiffImageParser.writeImage(image, (OutputStream)baos, params);
                    compressed = baos.toByteArray();
                }
                finally {
                    baos.close();
                }
                result = Imaging.getBufferedImage((byte[])compressed);
                this.compareImages(image, result);
            }
            catch (IOException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                params = new TiffImagingParameters();
                params.setCompression(Integer.valueOf(3));
                params.setT4Options(Integer.valueOf(5));
                baos = new ByteArrayOutputStream();
                try {
                    tiffImageParser.writeImage(image, (OutputStream)baos, params);
                    compressed = baos.toByteArray();
                }
                finally {
                    baos.close();
                }
                result = Imaging.getBufferedImage((byte[])compressed);
                this.compareImages(image, result);
            }
            catch (IOException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
            try {
                params = new TiffImagingParameters();
                params.setCompression(Integer.valueOf(4));
                baos = new ByteArrayOutputStream();
                try {
                    tiffImageParser.writeImage(image, (OutputStream)baos, params);
                    compressed = baos.toByteArray();
                }
                finally {
                    baos.close();
                }
                result = Imaging.getBufferedImage((byte[])compressed);
                this.compareImages(image, result);
            }
            catch (IOException ex) {
                Debug.debug((Throwable)ex);
                Assertions.fail();
            }
        } while (TiffCcittTest.nextCombination(combinations, 1));
    }
}

