/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.txt;

import java.io.Closeable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.core.internal.SimpleTextParser;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.SimpleFacetDefinition;

public class TextFacetDefinitionReader
implements FacetDefinitionReader {
    public static final String DEFAULT_COMMENT_TOKEN = "#";
    private final Reader reader;
    private final SimpleTextParser parser;
    private String commentToken;
    private boolean hasCommentToken;
    private int commentStartChar;

    public TextFacetDefinitionReader(Reader reader) {
        this(reader, DEFAULT_COMMENT_TOKEN);
    }

    public TextFacetDefinitionReader(Reader reader, String commentToken) {
        this.reader = reader;
        this.parser = new SimpleTextParser(reader);
        this.setCommentTokenInternal(commentToken);
    }

    public String getCommentToken() {
        return this.commentToken;
    }

    public void setCommentToken(String commentToken) {
        this.setCommentTokenInternal(commentToken);
    }

    @Override
    public FacetDefinition readFacet() {
        this.discardNonDataLines();
        if (this.parser.hasMoreCharacters()) {
            try {
                FacetDefinition facetDefinition = this.readFacetInternal();
                return facetDefinition;
            }
            finally {
                this.parser.discardLine();
            }
        }
        return null;
    }

    @Override
    public void close() {
        GeometryIOUtils.closeUnchecked((Closeable)this.reader);
    }

    private FacetDefinition readFacetInternal() {
        List<Object> vertices;
        Vector3D p1 = this.readVector();
        this.discardNonData();
        Vector3D p2 = this.readVector();
        this.discardNonData();
        Vector3D p3 = this.readVector();
        this.discardNonData();
        if (this.parser.hasMoreCharactersOnLine()) {
            vertices = new ArrayList<Vector3D>();
            vertices.add(p1);
            vertices.add(p2);
            vertices.add(p3);
            do {
                vertices.add(this.readVector());
                this.discardNonData();
            } while (this.parser.hasMoreCharactersOnLine());
        } else {
            vertices = Arrays.asList(p1, p2, p3);
        }
        return new SimpleFacetDefinition(vertices);
    }

    private Vector3D readVector() {
        double x = this.readDouble();
        this.discardNonData();
        double y = this.readDouble();
        this.discardNonData();
        double z = this.readDouble();
        return Vector3D.of((double)x, (double)y, (double)z);
    }

    private double readDouble() {
        return this.parser.next(TextFacetDefinitionReader::isDataTokenPart).getCurrentTokenAsDouble();
    }

    private void discardNonDataLines() {
        this.parser.discardLineWhitespace();
        while (this.parser.hasMoreCharacters() && (!this.parser.hasMoreCharactersOnLine() || this.foundComment())) {
            this.parser.discardLine().discardLineWhitespace();
        }
    }

    private void discardNonData() {
        this.parser.discard(c -> !SimpleTextParser.isNewLinePart((int)c) && !TextFacetDefinitionReader.isDataTokenPart(c) && c != this.commentStartChar);
        if (this.foundComment()) {
            this.parser.discard(SimpleTextParser::isNotNewLinePart);
        }
    }

    private boolean foundComment() {
        return this.hasCommentToken && this.commentToken.equals(this.parser.peek(this.commentToken.length()));
    }

    private void setCommentTokenInternal(String commentTokenStr) {
        if (commentTokenStr != null && TextFacetDefinitionReader.containsWhitespace(commentTokenStr)) {
            throw new IllegalArgumentException("Comment token cannot contain whitespace; was [" + commentTokenStr + "]");
        }
        this.commentToken = commentTokenStr;
        this.hasCommentToken = commentTokenStr != null && commentTokenStr.length() > 0;
        this.commentStartChar = this.hasCommentToken ? (int)commentTokenStr.charAt(0) : -1;
    }

    private static boolean isDataTokenPart(int ch) {
        return Character.isAlphabetic(ch) || SimpleTextParser.isDecimalPart((int)ch);
    }

    private static boolean containsWhitespace(String str) {
        for (char ch : str.toCharArray()) {
            if (!Character.isWhitespace(ch)) continue;
            return true;
        }
        return false;
    }
}

