/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.nio.ByteBuffer;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlConstants;

final class StlUtils {
    private StlUtils() {
    }

    static ByteBuffer byteBuffer(int capacity) {
        return ByteBuffer.allocate(capacity).order(StlConstants.BINARY_BYTE_ORDER);
    }

    static Vector3D determineNormal(Vector3D p1, Vector3D p2, Vector3D p3, Vector3D normal) {
        Vector3D.Unit normalized;
        if (normal != null && (normalized = normal.normalizeOrNull()) != null) {
            return normalized;
        }
        Vector3D computed = StlUtils.computeTriangleNormal(p1, p2, p3);
        return computed != null ? computed : Vector3D.ZERO;
    }

    static boolean pointsAreCounterClockwise(Vector3D p1, Vector3D p2, Vector3D p3, Vector3D normal) {
        Vector3D computedNormal;
        return normal == null || (computedNormal = StlUtils.computeTriangleNormal(p1, p2, p3)) == null || !(normal.dot(computedNormal) < 0.0);
    }

    private static Vector3D computeTriangleNormal(Vector3D p1, Vector3D p2, Vector3D p3) {
        Vector3D.Unit normal = p1.vectorTo(p2).cross(p1.vectorTo(p3)).normalizeOrNull();
        return normal != null ? normal : null;
    }
}

