/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.text.MessageFormat;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Ray;
import org.apache.commons.geometry.euclidean.twod.ReverseRay;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

final class LineSpanningSubset
extends LineConvexSubset {
    LineSpanningSubset(Line line) {
        super(line);
    }

    public boolean isFull() {
        return true;
    }

    public boolean isInfinite() {
        return true;
    }

    public boolean isFinite() {
        return false;
    }

    public double getSize() {
        return Double.POSITIVE_INFINITY;
    }

    public Vector2D getCentroid() {
        return null;
    }

    @Override
    public Vector2D getStartPoint() {
        return null;
    }

    @Override
    public double getSubspaceStart() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Vector2D getEndPoint() {
        return null;
    }

    @Override
    public double getSubspaceEnd() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Bounds2D getBounds() {
        return null;
    }

    @Override
    public LineSpanningSubset transform(Transform<Vector2D> transform) {
        return new LineSpanningSubset(this.getLine().transform(transform));
    }

    @Override
    public LineSpanningSubset reverse() {
        return new LineSpanningSubset(this.getLine().reverse());
    }

    public String toString() {
        Line line = this.getLine();
        return MessageFormat.format("{0}[origin= {1}, direction= {2}]", this.getClass().getSimpleName(), line.getOrigin(), line.getDirection());
    }

    @Override
    RegionLocation classifyAbscissa(double abscissa) {
        return RegionLocation.INSIDE;
    }

    @Override
    double closestAbscissa(double abscissa) {
        return abscissa;
    }

    @Override
    Split<LineConvexSubset> splitOnIntersection(Line splitter, Vector2D intersection) {
        Line line = this.getLine();
        ReverseRay low = new ReverseRay(line, intersection);
        Ray high = new Ray(line, intersection);
        return this.createSplitResult(splitter, low, high);
    }
}

