/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.AbstractRequestContext;
import org.apache.commons.fileupload2.core.AbstractTest;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.MultipartInput;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractStreamingTest<AFU extends AbstractFileUpload<R, I, F>, R, C extends AbstractRequestContext<?>, I extends FileItem<I>, F extends FileItemFactory<I>>
extends AbstractTest<AFU, R, I, F> {
    protected String getFooter() {
        return "-----1234--\r\n";
    }

    protected String getHeader(String value) {
        return "-----1234\r\nContent-Disposition: form-data; name=\"" + value + "\"\r\n\r\n";
    }

    protected abstract F newDiskFileItemFactory();

    protected byte[] newRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.US_ASCII);){
            int add = 16;
            int num = 0;
            for (int i = 0; i < 16384; i += add) {
                if (++add == 32) {
                    add = 16;
                }
                osw.write(this.getHeader("field" + num++));
                osw.flush();
                for (int j = 0; j < i; ++j) {
                    baos.write((byte)j);
                }
                osw.write("\r\n");
            }
            osw.write(this.getFooter());
        }
        return baos.toByteArray();
    }

    protected abstract C newServletRequestContext(R var1);

    protected byte[] newShortRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.US_ASCII);){
            osw.write(this.getHeader("field"));
            osw.write("123");
            osw.write("\r\n");
            osw.write(this.getFooter());
        }
        return baos.toByteArray();
    }

    protected List<I> parseUpload(byte[] bytes) throws FileUploadException {
        return this.parseUpload(new ByteArrayInputStream(bytes), bytes.length);
    }

    protected List<I> parseUpload(InputStream inputStream, int length) throws FileUploadException {
        String contentType = "multipart/form-data; boundary=---1234";
        Object upload = this.newFileUpload();
        upload.setFileItemFactory(this.newDiskFileItemFactory());
        Object request = this.newMockHttpServletRequest(inputStream, length, "multipart/form-data; boundary=---1234", -1);
        return upload.parseRequest(this.newServletRequestContext(request));
    }

    protected FileItemInputIterator parseUpload(int length, InputStream inputStream) throws FileUploadException, IOException {
        String contentType = "multipart/form-data; boundary=---1234";
        Object upload = this.newFileUpload();
        upload.setFileItemFactory(this.newDiskFileItemFactory());
        Object request = this.newMockHttpServletRequest(inputStream, length, "multipart/form-data; boundary=---1234", -1);
        return upload.getItemIterator(this.newServletRequestContext(request));
    }

    @Test
    void testFileUpload() throws IOException {
        byte[] request = this.newRequest();
        List<I> fileItems = this.parseUpload(request);
        Iterator<I> fileIter = fileItems.iterator();
        int add = 16;
        int num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            FileItem item = (FileItem)fileIter.next();
            Assertions.assertEquals((Object)("field" + num++), (Object)item.getFieldName());
            byte[] bytes = item.get();
            Assertions.assertEquals((int)i, (int)bytes.length);
            for (int j = 0; j < i; ++j) {
                Assertions.assertEquals((byte)((byte)j), (byte)bytes[j]);
            }
        }
        Assertions.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    void testFILEUPLOAD135() throws IOException {
        byte[] request = this.newShortRequest();
        final ByteArrayInputStream bais = new ByteArrayInputStream(request);
        List<I> fileItems = this.parseUpload(new InputStream(){

            @Override
            public int read() throws IOException {
                return bais.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return bais.read(b, off, Math.min(len, 3));
            }
        }, request.length);
        Iterator<I> fileIter = fileItems.iterator();
        Assertions.assertTrue((boolean)fileIter.hasNext());
        FileItem item = (FileItem)fileIter.next();
        Assertions.assertEquals((Object)"field", (Object)item.getFieldName());
        byte[] bytes = item.get();
        Assertions.assertEquals((int)3, (int)bytes.length);
        Assertions.assertEquals((byte)49, (byte)bytes[0]);
        Assertions.assertEquals((byte)50, (byte)bytes[1]);
        Assertions.assertEquals((byte)51, (byte)bytes[2]);
        Assertions.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    void testFileUploadException() throws IOException {
        byte[] request = this.newRequest();
        byte[] invalidRequest = new byte[request.length - 11];
        System.arraycopy(request, 0, invalidRequest, 0, request.length - 11);
        try {
            this.parseUpload(invalidRequest);
            Assertions.fail((String)"Expected EndOfStreamException");
        }
        catch (FileUploadException e) {
            Assertions.assertTrue((boolean)(e.getSuppressed()[0] instanceof MultipartInput.MalformedStreamException), (String)e.toString());
        }
    }

    @Test
    void testInvalidFileNameException() throws IOException {
        String fileName = "foo.exe\u0000.png";
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.exe\u0000.png\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] reqBytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.exe\u0000.png\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n".getBytes(StandardCharsets.US_ASCII);
        FileItemInputIterator fileItemIter = this.parseUpload(reqBytes.length, new ByteArrayInputStream(reqBytes));
        FileItemInput fileItemInput = fileItemIter.next();
        try {
            fileItemInput.getName();
            Assertions.fail((String)"Expected exception");
        }
        catch (InvalidPathException e) {
            Assertions.assertEquals((Object)"foo.exe\u0000.png", (Object)e.getInput());
            Assertions.assertEquals((int)26, (int)e.getMessage().indexOf("foo.exe\u0000.png"));
            Assertions.assertEquals((int)7, (int)e.getIndex());
            Assertions.assertTrue((boolean)e.getMessage().contains("foo.exe\\0.png"));
        }
        try {
            this.parseUpload(reqBytes);
            Assertions.fail((String)"Expected exception");
        }
        catch (InvalidPathException e) {
            Assertions.assertEquals((Object)"foo.exe\u0000.png", (Object)e.getInput());
            Assertions.assertEquals((int)26, (int)e.getMessage().indexOf("foo.exe\u0000.png"));
            Assertions.assertEquals((int)7, (int)e.getIndex());
            Assertions.assertTrue((boolean)e.getMessage().contains("foo.exe\\0.png"));
        }
    }

    @Test
    void testIOException() throws IOException {
        byte[] request = this.newRequest();
        FilterInputStream stream = new FilterInputStream(new ByteArrayInputStream(request)){
            private int num;

            @Override
            public int read() throws IOException {
                if (++this.num > 123) {
                    throw new IOException("123");
                }
                return super.read();
            }

            @Override
            public int read(byte[] buffer, int offset, int length) throws IOException {
                for (int i = 0; i < length; ++i) {
                    int res = this.read();
                    if (res == -1) {
                        return i == 0 ? -1 : i;
                    }
                    buffer[offset + i] = (byte)res;
                }
                return length;
            }
        };
        try {
            this.parseUpload(stream, request.length);
            Assertions.fail((String)"Expected IOException");
        }
        catch (FileUploadException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof IOException));
            Assertions.assertEquals((Object)"123", (Object)e.getCause().getMessage());
        }
    }
}

