/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta.util;

import jakarta.mail.internet.InternetAddress;
import org.apache.commons.mail2.jakarta.util.IDNEmailAddressConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IDNEmailAddressConverterTest {
    private static final String AUSTRIAN_IDN_EMAIL_ADDRESS = "noreply@d\u00f6m\u00e4in.example";
    private static final String CZECH_IDN_EMAIL_ADDRESS = "noreply@\u010desk\u00e1republika.icom.museum";
    private static final String RUSSIAN_IDN_EMAIL_ADDRESS = "noreply@\u0440\u043e\u0441\u0441\u0438\u044f.\u0438\u043a\u043e\u043c.museum";
    private static final String GERMAN_IDN_EMAIL_NAME = "noreply@d\u00f6m\u00e4in.example";
    private static final String[] IDN_EMAIL_ADDRESSES = new String[]{"noreply@d\u00f6m\u00e4in.example", "noreply@\u010desk\u00e1republika.icom.museum", "noreply@\u0440\u043e\u0441\u0441\u0438\u044f.\u0438\u043a\u043e\u043c.museum"};
    private final IDNEmailAddressConverter idnEmailConverter = new IDNEmailAddressConverter();

    @Test
    public void testConvertInvalidEmailAddressToAscii() {
        Assertions.assertNull((Object)this.idnEmailConverter.toASCII(null));
        Assertions.assertEquals((Object)"", (Object)this.idnEmailConverter.toASCII(""));
        Assertions.assertEquals((Object)"@", (Object)this.idnEmailConverter.toASCII("@"));
        Assertions.assertEquals((Object)"@@", (Object)this.idnEmailConverter.toASCII("@@"));
        Assertions.assertEquals((Object)"foo", (Object)this.idnEmailConverter.toASCII("foo"));
        Assertions.assertEquals((Object)"foo@", (Object)this.idnEmailConverter.toASCII("foo@"));
        Assertions.assertEquals((Object)"@badhost.com", (Object)this.idnEmailConverter.toASCII("@badhost.com"));
    }

    @Test
    public void testIDNEmailAddressToAsciiConversion() {
        Assertions.assertEquals((Object)"noreply@xn--dmin-moa0i.example", (Object)this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example"));
        Assertions.assertEquals((Object)"noreply@xn--h1alffa9f.xn--h1aegh.museum", (Object)this.idnEmailConverter.toASCII(RUSSIAN_IDN_EMAIL_ADDRESS));
    }

    @Test
    public void testInternetAddressToAsciiConversion() throws Exception {
        InternetAddress address = new InternetAddress(this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example"));
        Assertions.assertEquals((Object)"noreply@d\u00f6m\u00e4in.example", (Object)this.idnEmailConverter.toUnicode(address));
        InternetAddress addressWithPersonalName = new InternetAddress(this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example"), "noreply@d\u00f6m\u00e4in.example");
        Assertions.assertEquals((Object)"noreply@d\u00f6m\u00e4in.example", (Object)this.idnEmailConverter.toUnicode(addressWithPersonalName));
    }

    @Test
    public void testMultipleIDNEmailAddressToAsciiConversion() {
        Assertions.assertEquals((Object)"noreply@xn--dmin-moa0i.example", (Object)this.idnEmailConverter.toASCII(this.idnEmailConverter.toASCII("noreply@d\u00f6m\u00e4in.example")));
    }

    @Test
    public void testNonIDNEmailAddressToAsciiConversion() {
        Assertions.assertEquals((Object)"me@home.com", (Object)this.idnEmailConverter.toASCII("me@home.com"));
    }

    @Test
    public void testRoundTripConversionOfIDNEmailAddress() {
        for (String email : IDN_EMAIL_ADDRESSES) {
            Assertions.assertEquals((Object)email, (Object)this.idnEmailConverter.toUnicode(this.idnEmailConverter.toASCII(email)));
        }
    }
}

