/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Iterator;
import org.apache.commons.configuration.JNDIConfiguration;
import org.apache.commons.configuration.TestJNDIConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNullJNDIEnvironmentValues {
    private JNDIConfiguration conf = null;

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", TestJNDIConfiguration.CONTEXT_FACTORY);
        this.conf = new JNDIConfiguration();
        this.conf.setThrowExceptionOnMissing(false);
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assert.assertFalse((String)"Throw Exception Property is set!", (boolean)this.conf.isThrowExceptionOnMissing());
    }

    @Test
    public void testSimpleGet() throws Exception {
        String s = this.conf.getString("test.key");
        Assert.assertEquals((Object)"jndivalue", (Object)s);
    }

    @Test
    public void testMoreGets() throws Exception {
        String s = this.conf.getString("test.key");
        Assert.assertEquals((Object)"jndivalue", (Object)s);
        Assert.assertEquals((Object)"jndivalue2", (Object)this.conf.getString("test.key2"));
        Assert.assertEquals((long)1L, (long)this.conf.getShort("test.short"));
    }

    @Test
    public void testGetMissingKey() throws Exception {
        Assert.assertNull((String)"Missing Key is not null!", (Object)this.conf.getString("test.imaginarykey"));
    }

    @Test
    public void testGetMissingKeyWithDefault() throws Exception {
        String result = this.conf.getString("test.imaginarykey", "bob");
        Assert.assertEquals((Object)"bob", (Object)result);
    }

    @Test
    public void testContainsKey() throws Exception {
        Assert.assertTrue((boolean)this.conf.containsKey("test.key"));
        Assert.assertTrue((!this.conf.containsKey("test.imaginarykey") ? 1 : 0) != 0);
    }

    @Test
    public void testClearProperty() {
        Assert.assertNotNull((String)"null short for the 'test.short' key", (Object)this.conf.getShort("test.short", null));
        this.conf.clearProperty("test.short");
        Assert.assertNull((String)"'test.short' property not cleared", (Object)this.conf.getShort("test.short", null));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertFalse((String)"the configuration shouldn't be empty", (boolean)this.conf.isEmpty());
    }

    @Test
    public void testGetKeys() throws Exception {
        boolean found = false;
        Iterator it = this.conf.getKeys();
        Assert.assertTrue((String)"no key found", (boolean)it.hasNext());
        while (it.hasNext() && !found) {
            found = "test.boolean".equals(it.next());
        }
        Assert.assertTrue((String)"'test.boolean' key not found", (boolean)found);
    }

    @Test
    public void testGetKeysWithUnknownPrefix() {
        Iterator it = this.conf.getKeys("foo.bar");
        Assert.assertFalse((String)"no key should be found", (boolean)it.hasNext());
    }

    @Test
    public void testGetKeysWithExistingPrefix() {
        Iterator it = this.conf.getKeys("test");
        boolean found = false;
        while (it.hasNext() && !found) {
            found = "test.boolean".equals(it.next());
        }
        Assert.assertTrue((String)"'test.boolean' key not found", (boolean)found);
    }

    @Test
    public void testGetKeysWithKeyAsPrefix() {
        Iterator it = this.conf.getKeys("test.boolean");
        boolean found = false;
        while (it.hasNext() && !found) {
            found = "test.boolean".equals(it.next());
        }
        Assert.assertTrue((String)"'test.boolean' key not found", (boolean)found);
    }
}

