/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ZipSplitReadOnlySeekableByteChannelTest {
    ZipSplitReadOnlySeekableByteChannelTest() {
    }

    private List<SeekableByteChannel> getSplitZipChannels() throws IOException {
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        File file1 = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        channels.add(Files.newByteChannel(file1.toPath(), StandardOpenOption.READ));
        File file2 = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        channels.add(Files.newByteChannel(file2.toPath(), StandardOpenOption.READ));
        File lastFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        channels.add(Files.newByteChannel(lastFile.toPath(), StandardOpenOption.READ));
        return channels;
    }

    @Test
    void testBuildFromLastSplitSegmentThrowsOnNotZipFile() throws IOException {
        File lastFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile));
    }

    @Test
    void testChannelsPositionIsZeroAfterConstructor() throws IOException {
        List<SeekableByteChannel> channels = this.getSplitZipChannels();
        try (ZipSplitReadOnlySeekableByteChannel c = new ZipSplitReadOnlySeekableByteChannel(channels);){
            for (SeekableByteChannel channel : channels) {
                Assertions.assertEquals((long)0L, (long)channel.position());
            }
        }
    }

    @Test
    void testConstructorThrowsOnNonSplitZipFiles() throws IOException {
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        File file = AbstractTest.getFile("COMPRESS-189.zip");
        try (SeekableByteChannel byteChannel = Files.newByteChannel(file.toPath(), StandardOpenOption.READ);){
            channels.add(byteChannel);
            Assertions.assertThrows(IOException.class, () -> new ZipSplitReadOnlySeekableByteChannel(channels));
        }
    }

    @Test
    void testConstructorThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> new ZipSplitReadOnlySeekableByteChannel(null));
    }

    @Test
    void testForFilesOfTwoParametersThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forFiles(null, null));
    }

    @Test
    void testForFilesReturnCorrectClass() throws IOException {
        File firstFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        File secondFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        File lastFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        ArrayList<File> list = new ArrayList<File>();
        list.add(firstFile);
        list.add(secondFile);
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forFiles((File)lastFile, list);){
            Assertions.assertInstanceOf(ZipSplitReadOnlySeekableByteChannel.class, (Object)channel);
        }
        channel = ZipSplitReadOnlySeekableByteChannel.forFiles((File[])new File[]{firstFile, secondFile, lastFile});
        try {
            Assertions.assertInstanceOf(ZipSplitReadOnlySeekableByteChannel.class, (Object)channel);
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    @Test
    void testForFilesThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forFiles((File[])null));
    }

    @Test
    void testForOrderedSeekableByteChannelsOfTwoParametersThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels(null, null));
    }

    @Test
    void testForOrderedSeekableByteChannelsReturnCorrectClass() throws IOException {
        File file1 = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        File file2 = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        File lastFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        try (SeekableByteChannel firstChannel = Files.newByteChannel(file1.toPath(), StandardOpenOption.READ);
             SeekableByteChannel secondChannel = Files.newByteChannel(file2.toPath(), StandardOpenOption.READ);
             SeekableByteChannel lastChannel = Files.newByteChannel(lastFile.toPath(), StandardOpenOption.READ);){
            ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
            channels.add(firstChannel);
            channels.add(secondChannel);
            SeekableByteChannel channel1 = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel)lastChannel, channels);
            Assertions.assertInstanceOf(ZipSplitReadOnlySeekableByteChannel.class, (Object)channel1);
            SeekableByteChannel channel2 = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{firstChannel, secondChannel, lastChannel});
            Assertions.assertInstanceOf(ZipSplitReadOnlySeekableByteChannel.class, (Object)channel2);
        }
    }

    @Test
    void testForOrderedSeekableByteChannelsReturnsIdentityForSingleElement() throws IOException {
        try (SeekableInMemoryByteChannel emptyChannel = new SeekableInMemoryByteChannel(ByteUtils.EMPTY_BYTE_ARRAY);
             SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{emptyChannel});){
            Assertions.assertSame((Object)emptyChannel, (Object)channel);
        }
    }

    @Test
    void testForOrderedSeekableByteChannelsThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel[])null));
    }

    @Test
    void testForPathsOfTwoParametersThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forPaths((Path)null, null));
    }

    @Test
    void testForPathsReturnCorrectClass() throws IOException {
        Path firstFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        Path secondFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        Path lastFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(firstFile);
        list.add(secondFile);
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forPaths((Path)lastFile, list);){
            Assertions.assertInstanceOf(ZipSplitReadOnlySeekableByteChannel.class, (Object)channel);
        }
        channel = ZipSplitReadOnlySeekableByteChannel.forPaths((Path[])new Path[]{firstFile, secondFile, lastFile});
        try {
            Assertions.assertInstanceOf(ZipSplitReadOnlySeekableByteChannel.class, (Object)channel);
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    @Test
    void testForPathsThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forPaths((Path[])null));
    }

    @Test
    void testPositionToSomeZipSplitSegment() throws IOException {
        File firstFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        int firstFileSize = (int)firstFile.length();
        File secondFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        int secondFileSize = (int)secondFile.length();
        File lastFile = AbstractTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        int lastFileSize = (int)lastFile.length();
        Random random = new Random();
        int randomDiskNumber = random.nextInt(3);
        int randomOffset = randomDiskNumber < 2 ? random.nextInt(firstFileSize) : random.nextInt(lastFileSize);
        try (ZipSplitReadOnlySeekableByteChannel channel = (ZipSplitReadOnlySeekableByteChannel)ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);){
            channel.position((long)randomDiskNumber, (long)randomOffset);
            long expectedPosition = randomOffset;
            expectedPosition += randomDiskNumber > 0 ? (long)firstFileSize : 0L;
            Assertions.assertEquals((long)(expectedPosition += randomDiskNumber > 1 ? (long)secondFileSize : 0L), (long)channel.position());
        }
    }
}

