/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.archivers.zip.SeekableChannelRandomAccessOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SeekableChannelRandomAccessOutputStreamTest
extends AbstractTempDirTest {
    SeekableChannelRandomAccessOutputStreamTest() {
    }

    @Test
    void testInitialization() throws IOException {
        Path file = this.newTempPath("testChannel");
        try (SeekableChannelRandomAccessOutputStream stream = new SeekableChannelRandomAccessOutputStream(Files.newByteChannel(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE));){
            Assertions.assertEquals((long)0L, (long)stream.position());
        }
    }

    @Test
    void testWrite() throws IOException {
        FileChannel channel = (FileChannel)Mockito.mock(FileChannel.class);
        SeekableChannelRandomAccessOutputStream stream = new SeekableChannelRandomAccessOutputStream((SeekableByteChannel)channel);
        Mockito.when((Object)channel.position()).thenReturn((Object)11L);
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(5);
            return 5;
        }).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(6);
            return 6;
        });
        stream.write("hello".getBytes(StandardCharsets.UTF_8));
        stream.write("world\n".getBytes(StandardCharsets.UTF_8));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
        Assertions.assertEquals((long)11L, (long)stream.position());
    }

    @Test
    void testWriteFullyAt_whenFullAtOnce_thenSucceed() throws IOException {
        try (SeekableByteChannel channel = (SeekableByteChannel)Mockito.mock(SeekableByteChannel.class);
             SeekableChannelRandomAccessOutputStream stream = new SeekableChannelRandomAccessOutputStream(channel);){
            Mockito.when((Object)channel.position()).thenReturn((Object)50L).thenReturn((Object)60L);
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(5);
                return 5;
            }).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(6);
                return 6;
            });
            stream.writeAll("hello".getBytes(StandardCharsets.UTF_8), 20L);
            stream.writeAll("world\n".getBytes(StandardCharsets.UTF_8), 30L);
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).position(ArgumentMatchers.eq((long)50L));
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).position(ArgumentMatchers.eq((long)60L));
            Assertions.assertEquals((long)60L, (long)stream.position());
        }
    }

    @Test
    void testWriteFullyAt_whenFullButPartial_thenSucceed() throws IOException {
        try (SeekableByteChannel channel = (SeekableByteChannel)Mockito.mock(SeekableByteChannel.class);
             SeekableChannelRandomAccessOutputStream stream = new SeekableChannelRandomAccessOutputStream(channel);){
            Mockito.when((Object)channel.position()).thenReturn((Object)50L).thenReturn((Object)60L);
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(3);
                return 3;
            }).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(5);
                return 2;
            }).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(6);
                return 6;
            });
            stream.writeAll("hello".getBytes(StandardCharsets.UTF_8), 20L);
            stream.writeAll("world\n".getBytes(StandardCharsets.UTF_8), 30L);
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).position(ArgumentMatchers.eq((long)50L));
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).position(ArgumentMatchers.eq((long)60L));
            Assertions.assertEquals((long)60L, (long)stream.position());
        }
    }

    @Test
    void testWriteFullyAt_whenPartial_thenFail() throws IOException {
        try (SeekableByteChannel channel = (SeekableByteChannel)Mockito.mock(SeekableByteChannel.class);
             SeekableChannelRandomAccessOutputStream stream = new SeekableChannelRandomAccessOutputStream(channel);){
            Mockito.when((Object)channel.position()).thenReturn((Object)50L);
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(3);
                return 3;
            }).thenAnswer(answer -> 0).thenAnswer(answer -> -1);
            Assertions.assertThrows(IOException.class, () -> stream.writeAll("hello".getBytes(StandardCharsets.UTF_8), 20L));
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
            Assertions.assertEquals((long)50L, (long)stream.position());
        }
    }
}

