/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.PredicatedCollection;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedCollectionTest<E>
extends AbstractCollectionTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = String.class::isInstance;

    protected Collection<E> decorateCollection(Collection<E> collection, Predicate<E> predicate) {
        return PredicatedCollection.predicatedCollection(collection, predicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new ArrayList<E>(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Collection<E> makeFullCollection() {
        ArrayList<E> list = new ArrayList<E>(Arrays.asList(this.getFullElements()));
        return this.decorateCollection(list, this.truePredicate);
    }

    @Override
    public Collection<E> makeObject() {
        return this.decorateCollection(new ArrayList(), this.truePredicate);
    }

    public Collection<E> makeTestCollection() {
        return this.decorateCollection(new ArrayList(), this.testPredicate);
    }

    @Test
    public void testIllegalAdd() {
        Collection c = this.makeTestCollection();
        Integer i = 3;
        Assertions.assertThrows(IllegalArgumentException.class, () -> c.add(i), (String)"Integer should fail string predicate.");
        Assertions.assertFalse((boolean)c.contains(i), (String)"Collection shouldn't contain illegal element");
    }

    @Test
    public void testIllegalAddAll() {
        Collection c = this.makeTestCollection();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add("one");
        elements.add("two");
        elements.add(3);
        elements.add("four");
        Assertions.assertThrows(IllegalArgumentException.class, () -> c.addAll(elements), (String)"Integer should fail string predicate.");
        Assertions.assertFalse((boolean)c.contains("one"), (String)"Collection shouldn't contain illegal element");
        Assertions.assertFalse((boolean)c.contains("two"), (String)"Collection shouldn't contain illegal element");
        Assertions.assertFalse((boolean)c.contains(3), (String)"Collection shouldn't contain illegal element");
        Assertions.assertFalse((boolean)c.contains("four"), (String)"Collection shouldn't contain illegal element");
    }
}

