/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;

public final class IncrementingHasher
implements Hasher {
    private final long initial;
    private final long increment;

    public IncrementingHasher(long initial, long increment) {
        this.initial = initial;
        this.increment = increment;
    }

    public IndexExtractor indices(final Shape shape) {
        Objects.requireNonNull(shape, "shape");
        return new IndexExtractor(){
            final /* synthetic */ IncrementingHasher this$0;
            {
                this.this$0 = this$0;
            }

            public int[] asIndexArray() {
                int[] result = new int[shape.getNumberOfHashFunctions()];
                int[] idx = new int[1];
                this.processIndices(i -> {
                    int n = idx[0];
                    idx[0] = n + 1;
                    result[n] = i;
                    return true;
                });
                return result;
            }

            public boolean processIndices(IntPredicate consumer) {
                Objects.requireNonNull(consumer, "consumer");
                int bits = shape.getNumberOfBits();
                long index = BitMaps.mod((long)this.this$0.initial, (int)bits);
                int inc = BitMaps.mod((long)this.this$0.increment, (int)bits);
                for (int functionalCount = 0; functionalCount < shape.getNumberOfHashFunctions(); ++functionalCount) {
                    if (!consumer.test((int)index)) {
                        return false;
                    }
                    index = (index += (long)inc) >= (long)bits ? index - (long)bits : index;
                }
                return true;
            }
        };
    }
}

