/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.QueueUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.queue.PredicatedQueue;
import org.apache.commons.collections4.queue.SynchronizedQueue;
import org.apache.commons.collections4.queue.TransformedQueue;
import org.apache.commons.collections4.queue.UnmodifiableQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueueUtilsTest {
    protected Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected Transformer<Object, Object> nopTransformer = TransformerUtils.nopTransformer();

    @Test
    public void testEmptyQueue() {
        Queue queue = QueueUtils.emptyQueue();
        Assertions.assertInstanceOf(UnmodifiableQueue.class, (Object)queue, (String)"Returned object should be an UnmodifiableQueue.");
        Assertions.assertTrue((boolean)queue.isEmpty(), (String)"Returned queue is not empty.");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> queue.add(new Object()), (String)"Expecting UnsupportedOperationException for empty queue.");
    }

    @Test
    public void testPredicatedQueue() {
        Queue queue = QueueUtils.predicatedQueue(new LinkedList(), this.truePredicate);
        Assertions.assertInstanceOf(PredicatedQueue.class, (Object)queue, (String)"Returned object should be a PredicatedQueue.");
        Assertions.assertThrows(NullPointerException.class, () -> QueueUtils.predicatedQueue(null, this.truePredicate), (String)"Expecting NullPointerException for null queue.");
        Assertions.assertThrows(NullPointerException.class, () -> QueueUtils.predicatedQueue(new LinkedList(), null), (String)"Expecting NullPointerException for null predicate.");
    }

    @Test
    public void testSynchronizedQueue() {
        Queue queue = QueueUtils.synchronizedQueue(new LinkedList());
        Assertions.assertInstanceOf(SynchronizedQueue.class, (Object)queue, (String)"Returned object should be a SynchronizedQueue.");
        Assertions.assertThrows(NullPointerException.class, () -> QueueUtils.synchronizedQueue(null), (String)"Expecting NullPointerException for null queue.");
    }

    @Test
    public void testTransformedQueue() {
        Queue queue = QueueUtils.transformingQueue(new LinkedList(), this.nopTransformer);
        Assertions.assertInstanceOf(TransformedQueue.class, (Object)queue, (String)"Returned object should be an TransformedQueue.");
        Assertions.assertThrows(NullPointerException.class, () -> QueueUtils.transformingQueue(null, this.nopTransformer), (String)"Expecting NullPointerException for null queue.");
        Assertions.assertThrows(NullPointerException.class, () -> QueueUtils.transformingQueue(new LinkedList(), null), (String)"Expecting NullPointerException for null transformer.");
    }

    @Test
    public void testUnmodifiableQueue() {
        Queue queue = QueueUtils.unmodifiableQueue(new LinkedList());
        Assertions.assertInstanceOf(UnmodifiableQueue.class, (Object)queue, (String)"Returned object should be an UnmodifiableQueue.");
        Assertions.assertThrows(NullPointerException.class, () -> QueueUtils.unmodifiableQueue(null), (String)"Expecting NullPointerException for null queue.");
        Assertions.assertSame((Object)queue, (Object)QueueUtils.unmodifiableQueue((Queue)queue), (String)"UnmodifiableQueue shall not be decorated");
    }
}

