/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.collections4.FluentIterable;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FluentIterableTest {
    private static final Predicate<Number> EVEN = input -> input.intValue() % 2 == 0;
    private Iterable<Integer> iterableA;
    private Iterable<Long> iterableB;
    private Iterable<Integer> iterableEven;
    private Iterable<Integer> iterableOdd;
    private Iterable<Integer> emptyIterable;

    @BeforeEach
    public void setUp() {
        ArrayList<Integer> collectionA = new ArrayList<Integer>();
        collectionA.add(1);
        collectionA.add(2);
        collectionA.add(2);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        this.iterableA = collectionA;
        LinkedList<Long> collectionB = new LinkedList<Long>();
        collectionB.add(5L);
        collectionB.add(4L);
        collectionB.add(4L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        this.iterableB = collectionB;
        this.iterableEven = Arrays.asList(2, 4, 6, 8, 10, 12);
        this.iterableOdd = Arrays.asList(1, 3, 5, 7, 9, 11);
        this.emptyIterable = Collections.emptyList();
    }

    @Test
    public void testAllMatch() {
        Assertions.assertTrue((boolean)FluentIterable.of(this.iterableEven).allMatch(EVEN));
        Assertions.assertFalse((boolean)FluentIterable.of(this.iterableOdd).allMatch(EVEN));
        Assertions.assertFalse((boolean)FluentIterable.of(this.iterableA).allMatch(EVEN));
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableEven).allMatch(null), (String)"expecting NullPointerException");
    }

    @Test
    public void testAnyMatch() {
        Assertions.assertTrue((boolean)FluentIterable.of(this.iterableEven).anyMatch(EVEN));
        Assertions.assertFalse((boolean)FluentIterable.of(this.iterableOdd).anyMatch(EVEN));
        Assertions.assertTrue((boolean)FluentIterable.of(this.iterableA).anyMatch(EVEN));
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableEven).anyMatch(null), (String)"expecting NullPointerException");
    }

    @Test
    public void testAppendElements() {
        FluentIterable it = FluentIterable.of(this.iterableA).append((Object[])new Integer[]{10, 20, 30});
        Assertions.assertEquals((int)(IterableUtils.size(this.iterableA) + 3), (int)IterableUtils.size((Iterable)it));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)1));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)10));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)20));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)30));
        Assertions.assertFalse((boolean)IterableUtils.contains((Iterable)it, (Object)40));
        FluentIterable empty = FluentIterable.of(this.emptyIterable).append((Object[])new Integer[0]);
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)empty));
    }

    @Test
    public void testAppendIterable() {
        List<Integer> listB = Arrays.asList(10, 20, 30);
        FluentIterable it = FluentIterable.of(this.iterableA).append(listB);
        Assertions.assertEquals((int)(IterableUtils.size(this.iterableA) + listB.size()), (int)IterableUtils.size((Iterable)it));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)1));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)10));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)20));
        Assertions.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)30));
        Assertions.assertFalse((boolean)IterableUtils.contains((Iterable)it, (Object)40));
    }

    @Test
    public void testAsEnumeration() {
        Enumeration enumeration = FluentIterable.of(this.iterableB).asEnumeration();
        List result = EnumerationUtils.toList((Enumeration)enumeration);
        Assertions.assertEquals(this.iterableB, (Object)result);
        enumeration = FluentIterable.empty().asEnumeration();
        Assertions.assertFalse((boolean)enumeration.hasMoreElements());
    }

    @Test
    public void testCollate() {
        List result = FluentIterable.of(this.iterableOdd).collate(this.iterableEven).toList();
        ArrayList combinedList = new ArrayList();
        CollectionUtils.addAll(combinedList, this.iterableOdd);
        CollectionUtils.addAll(combinedList, this.iterableEven);
        Collections.sort(combinedList);
        Assertions.assertEquals(combinedList, (Object)result);
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableOdd).collate(null).toList(), (String)"expecting NullPointerException");
    }

    @Test
    public void testCollateWithComparator() {
        List result = FluentIterable.of(this.iterableOdd).collate(this.iterableEven, ComparatorUtils.naturalComparator()).toList();
        ArrayList combinedList = new ArrayList();
        CollectionUtils.addAll(combinedList, this.iterableOdd);
        CollectionUtils.addAll(combinedList, this.iterableEven);
        Collections.sort(combinedList);
        Assertions.assertEquals(combinedList, (Object)result);
        result = FluentIterable.of(this.iterableOdd).collate(this.iterableEven, null).toList();
        Assertions.assertEquals(combinedList, (Object)result);
    }

    @Test
    public void testContains() {
        Assertions.assertTrue((boolean)FluentIterable.of(this.iterableEven).contains((Object)2));
        Assertions.assertFalse((boolean)FluentIterable.of(this.iterableEven).contains((Object)1));
        Assertions.assertFalse((boolean)FluentIterable.of(this.iterableEven).contains(null));
        Assertions.assertTrue((boolean)FluentIterable.of(this.iterableEven).append((Object[])new Integer[]{null}).contains(null));
    }

    @Test
    public void testCopyInto() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        FluentIterable.of(this.iterableA).copyInto(result);
        ArrayList<Integer> expected = IterableUtils.toList(this.iterableA);
        Assertions.assertEquals((int)expected.size(), (int)result.size());
        Assertions.assertEquals((Object)expected, result);
        result = new ArrayList();
        result.add(10);
        result.add(9);
        result.add(8);
        FluentIterable.of(this.iterableA).copyInto(result);
        expected = new ArrayList<Integer>(Arrays.asList(10, 9, 8));
        expected.addAll(IterableUtils.toList(this.iterableA));
        Assertions.assertEquals((int)expected.size(), (int)result.size());
        Assertions.assertEquals(expected, result);
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableA).copyInto(null), (String)"expecting NullPointerException");
    }

    @Test
    public void testEval() {
        ArrayList<Integer> listNumbers = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
        FluentIterable iterable = FluentIterable.of(listNumbers).filter(EVEN);
        FluentIterable materialized = iterable.eval();
        listNumbers.addAll(Arrays.asList(11, 12, 13, 14, 15, 16, 17, 18, 19, 20));
        Assertions.assertEquals((int)5, (int)materialized.size());
        Assertions.assertEquals((int)10, (int)iterable.size());
        Assertions.assertEquals(Arrays.asList(2, 4, 6, 8, 10), (Object)materialized.toList());
        Assertions.assertEquals(Arrays.asList(2, 4, 6, 8, 10, 12, 14, 16, 18, 20), (Object)iterable.toList());
    }

    @Test
    public void testFactoryMethodOf() {
        FluentIterable iterable = FluentIterable.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        List result = iterable.toList();
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)result);
        iterable = FluentIterable.of((Object)1);
        Assertions.assertEquals((int)1, (int)iterable.size());
        Assertions.assertFalse((boolean)iterable.isEmpty());
        Assertions.assertEquals(Arrays.asList(1), (Object)iterable.toList());
        result = FluentIterable.of((Object[])new Integer[0]).toList();
        Assertions.assertTrue((boolean)result.isEmpty());
        Iterable it = null;
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of((Iterable)it).toList(), (String)"expecting NullPointerException");
    }

    @Test
    public void testFilter() {
        Predicate smallerThan3 = object -> object < 3;
        List result = FluentIterable.of(this.iterableA).filter(smallerThan3).toList();
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals(Arrays.asList(1, 2, 2), (Object)result);
        result = FluentIterable.of(this.emptyIterable).filter(smallerThan3).toList();
        Assertions.assertEquals((int)0, (int)result.size());
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableA).filter(null).toList(), (String)"expecting NullPointerException");
    }

    @Test
    public void testForEach() {
        AtomicInteger sum = new AtomicInteger();
        Closure closure = sum::addAndGet;
        FluentIterable.of(this.iterableA).forEach(closure);
        int expectedSum = 0;
        for (Integer i : this.iterableA) {
            expectedSum += i.intValue();
        }
        Assertions.assertEquals((int)expectedSum, (int)sum.get());
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableA).forEach((Closure)null), (String)"expecting NullPointerException");
    }

    @Test
    public void testGet() {
        Assertions.assertEquals((int)2, (int)((Integer)FluentIterable.of(this.iterableEven).get(0)));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> FluentIterable.of(this.iterableEven).get(-1), (String)"expecting IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> FluentIterable.of(this.iterableEven).get(IterableUtils.size(this.iterableEven)), (String)"expecting IndexOutOfBoundsException");
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)FluentIterable.of(this.emptyIterable).isEmpty());
        Assertions.assertFalse((boolean)FluentIterable.of(this.iterableOdd).isEmpty());
    }

    @Test
    public void testIterator() {
        Iterator iterator = FluentIterable.of(this.iterableA).iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        iterator = FluentIterable.empty().iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testLimit() {
        List result = FluentIterable.of(this.iterableA).limit(3L).toList();
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals(Arrays.asList(1, 2, 2), (Object)result);
        result = FluentIterable.of(this.iterableA).limit(100L).toList();
        List expected = IterableUtils.toList(this.iterableA);
        Assertions.assertEquals((int)expected.size(), (int)result.size());
        Assertions.assertEquals((Object)expected, (Object)result);
        result = FluentIterable.of(this.iterableA).limit(0L).toList();
        Assertions.assertEquals((int)0, (int)result.size());
        result = FluentIterable.of(this.emptyIterable).limit(3L).toList();
        Assertions.assertEquals((int)0, (int)result.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> FluentIterable.of(this.iterableA).limit(-2L).toList(), (String)"expecting IllegalArgumentException");
    }

    @Test
    public void testReverse() {
        List result = FluentIterable.of(this.iterableA).reverse().toList();
        List expected = IterableUtils.toList(this.iterableA);
        Collections.reverse(expected);
        Assertions.assertEquals((Object)expected, (Object)result);
        result = FluentIterable.of(this.emptyIterable).reverse().toList();
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)0, (int)FluentIterable.of(this.emptyIterable).size());
        Assertions.assertEquals((int)IterableUtils.toList(this.iterableOdd).size(), (int)FluentIterable.of(this.iterableOdd).size());
    }

    @Test
    public void testSkip() {
        List result = FluentIterable.of(this.iterableA).skip(4L).toList();
        Assertions.assertEquals((int)6, (int)result.size());
        Assertions.assertEquals(Arrays.asList(3, 3, 4, 4, 4, 4), (Object)result);
        result = FluentIterable.of(this.iterableA).skip(100L).toList();
        Assertions.assertEquals((int)0, (int)result.size());
        result = FluentIterable.of(this.iterableA).skip(0L).toList();
        List expected = IterableUtils.toList(this.iterableA);
        Assertions.assertEquals((int)expected.size(), (int)result.size());
        Assertions.assertEquals((Object)expected, (Object)result);
        result = FluentIterable.of(this.emptyIterable).skip(3L).toList();
        Assertions.assertEquals((int)0, (int)result.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> FluentIterable.of(this.iterableA).skip(-4L).toList(), (String)"expecting IllegalArgumentException");
    }

    @Test
    public void testToArray() {
        Object[] arr = new Long[]{1L, 2L, 3L, 4L, 5L};
        Object[] result = (Long[])FluentIterable.of((Object[])arr).toArray(Long.class);
        Assertions.assertNotNull((Object)result);
        Assertions.assertArrayEquals((Object[])arr, (Object[])result);
        Assertions.assertThrows(ArrayStoreException.class, () -> FluentIterableTest.lambda$testToArray$13((Long[])arr));
    }

    @Test
    public void testToString() {
        String result = FluentIterable.of(this.iterableA).toString();
        Assertions.assertEquals((Object)this.iterableA.toString(), (Object)result);
        result = FluentIterable.empty().toString();
        Assertions.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void testTransform() {
        Transformer squared = object -> object * object;
        List result = FluentIterable.of(this.iterableA).transform(squared).toList();
        Assertions.assertEquals((int)10, (int)result.size());
        Assertions.assertEquals(Arrays.asList(1, 4, 4, 9, 9, 9, 16, 16, 16, 16), (Object)result);
        result = FluentIterable.of(this.emptyIterable).transform(squared).toList();
        Assertions.assertEquals((int)0, (int)result.size());
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableA).transform(null).toList(), (String)"expecting NullPointerException");
    }

    @Test
    public void testUnique() {
        List result = FluentIterable.of(this.iterableA).unique().toList();
        Assertions.assertEquals((int)4, (int)result.size());
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)result);
        result = FluentIterable.of(this.emptyIterable).unique().toList();
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    public void testUnmodifiable() {
        FluentIterable iterable1 = FluentIterable.of(this.iterableA).unmodifiable();
        Iterator it = iterable1.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)it.next()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> it.remove(), (String)"expecting UnsupportedOperationException");
        FluentIterable iterable2 = iterable1.unmodifiable();
        Assertions.assertSame((Object)iterable1, (Object)iterable2);
    }

    @Test
    public void testZip() {
        List result = FluentIterable.of(this.iterableOdd).zip(this.iterableEven).toList();
        List<Object> combinedList = new ArrayList();
        CollectionUtils.addAll(combinedList, this.iterableOdd);
        CollectionUtils.addAll(combinedList, this.iterableEven);
        Collections.sort(combinedList);
        Assertions.assertEquals(combinedList, (Object)result);
        Assertions.assertThrows(NullPointerException.class, () -> FluentIterable.of(this.iterableOdd).zip((Iterable)null).toList(), (String)"expecting NullPointerException");
        result = FluentIterable.of(Arrays.asList(1, 4, 7)).zip(new Iterable[]{Arrays.asList(2, 5, 8), Arrays.asList(3, 6, 9)}).toList();
        combinedList = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9);
        Assertions.assertEquals(combinedList, (Object)result);
    }

    private static /* synthetic */ void lambda$testToArray$13(Long[] arr) throws Throwable {
        FluentIterable.of((Object[])arr).toArray(String.class);
    }
}

