/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.EnumConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EnumConverterTest {
    private Converter<Enum<PizzaStatus>> converter;

    protected Class<?> getExpectedType() {
        return Enum.class;
    }

    protected Converter<Enum<PizzaStatus>> makeConverter() {
        return new EnumConverter();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        int i;
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from String"};
        Object[] input = new Object[]{"DELIVERED", "ORDERED", "READY"};
        PizzaStatus[] expected = new PizzaStatus[]{PizzaStatus.DELIVERED, PizzaStatus.ORDERED, PizzaStatus.READY};
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)((Object)expected[i]), (Object)this.converter.convert(PizzaStatus.class, input[i]), (String)(message[i] + " to Enum"));
        }
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)input[i], (Object)this.converter.convert(String.class, (Object)expected[i]), (String)(input[i] + " to String"));
        }
    }

    @Test
    public void testUnsupportedType() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Integer.class, (Object)"http://www.apache.org"));
    }

    public static enum PizzaStatus {
        ORDERED,
        READY,
        DELIVERED;

    }
}

