/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.bugs.FirstChildBean;
import org.apache.commons.beanutils2.bugs.RootBean;
import org.apache.commons.beanutils2.bugs.SecondChildBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class Jira422Test {
    @BeforeAll
    public static void assumeSupportsIndexedLists() throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(RootBean.class);
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals("file")) continue;
            Assumptions.assumeTrue((boolean)(pd instanceof IndexedPropertyDescriptor), (String)"BEANUTILS-492: IndexedPropertyDescriptor no longer supported for java.util.List");
            return;
        }
        Assertions.fail((String)"Could not find PropertyDescriptor for 'file'");
    }

    @Test
    public void testRootBean() throws Exception {
        FirstChildBean bean = new FirstChildBean();
        Class propertyType = PropertyUtils.getPropertyType((Object)bean, (String)"file[0]");
        Assertions.assertEquals((Object)String.class.getName(), (Object)propertyType.getName());
    }

    @Test
    public void testSecondChildBean() throws Exception {
        SecondChildBean bean = new SecondChildBean();
        Class propertyType = PropertyUtils.getPropertyType((Object)bean, (String)"file[0]");
        Assertions.assertEquals((Object)String.class.getName(), (Object)propertyType.getName());
    }
}

