/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.bugs.other.Jira492IndexedListsSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Jira492TestCase {
    private final BeanUtilsBean beanUtils = new BeanUtilsBean();
    private final PropertyUtilsBean propertyUtils = new PropertyUtilsBean();
    private Jira492IndexedListsSupport.IndexedBean bean;

    @Test
    public void describe() throws Exception {
        Map described = this.beanUtils.describe((Object)this.bean);
        Assert.assertEquals((Object)"item0", described.get("someList"));
    }

    public void getArrayProperty() throws Exception {
        String[] arr = this.beanUtils.getArrayProperty((Object)this.bean, "someList");
        Assert.assertEquals((long)2L, (long)arr.length);
        Assert.assertEquals((Object)"item0", (Object)arr[0]);
        Assert.assertEquals((Object)"item1", (Object)arr[1]);
    }

    @Test
    public void getIndexedProperty() throws Exception {
        Assert.assertEquals((Object)"item0", (Object)this.beanUtils.getIndexedProperty((Object)this.bean, "someList", 0));
        Assert.assertEquals((Object)"item1", (Object)this.beanUtils.getIndexedProperty((Object)this.bean, "someList[1]"));
    }

    @Test
    public void getProperty() throws Exception {
        Assert.assertEquals((Object)"item0", (Object)this.beanUtils.getProperty((Object)this.bean, "someList"));
    }

    @Test
    public void getPropertyDescriptor() throws Exception {
        PropertyDescriptor propDesc = this.propertyUtils.getPropertyDescriptor((Object)this.bean, "someList");
        if (Jira492IndexedListsSupport.supportsIndexedLists()) {
            IndexedPropertyDescriptor indexed = (IndexedPropertyDescriptor)propDesc;
            Assert.assertEquals(String.class, indexed.getIndexedReadMethod().getReturnType());
        }
    }

    @Test
    public void getPropertySubScript() throws Exception {
        Assert.assertEquals((Object)"item0", (Object)this.beanUtils.getProperty((Object)this.bean, "someList[0]"));
        Assert.assertEquals((Object)"item1", (Object)this.beanUtils.getProperty((Object)this.bean, "someList[1]"));
    }

    @Test
    public void getPropertyType() throws Exception {
        if (Jira492IndexedListsSupport.supportsIndexedLists()) {
            Assert.assertEquals(String.class, (Object)this.propertyUtils.getPropertyType((Object)this.bean, "someList[0]"));
        } else {
            Assert.assertEquals(List.class, (Object)this.propertyUtils.getPropertyType((Object)this.bean, "someList"));
        }
    }

    @Test
    public void getPropertyUnconverted() throws Exception {
        Object someList = this.propertyUtils.getProperty((Object)this.bean, "someList");
        Assert.assertTrue((String)"Did not retrieve list", (boolean)(someList instanceof List));
    }

    @Before
    public void makeBean() {
        this.bean = new Jira492IndexedListsSupport.IndexedBean();
        this.bean.setSomeList(Arrays.asList("item0", "item1"));
    }

    @Test
    public void setIndexedProperty() throws Exception {
        this.beanUtils.setProperty((Object)this.bean, "someList[1]", (Object)"item1-modified");
        Assert.assertEquals((Object)"item1-modified", (Object)this.beanUtils.getIndexedProperty((Object)this.bean, "someList", 1));
    }
}

