/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.logging;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.LoggerFormatter;
import io.vertx.ext.web.handler.LoggerHandler;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarLoggerHandler
implements LoggerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarLoggerHandler.class);
    private final LoggerHandler loggerHandler;

    private SidecarLoggerHandler(LoggerHandler loggerHandler) {
        this.loggerHandler = loggerHandler;
    }

    public static LoggerHandler create(LoggerHandler handler) {
        return new SidecarLoggerHandler(handler);
    }

    public void handle(RoutingContext context) {
        context.addBodyEndHandler(v -> {
            if (context.statusCode() >= 500 && context.failure() != null) {
                LOGGER.error("Server error code={}, path={}, params={}", new Object[]{context.statusCode(), context.request().path(), this.toJson(context.request().params()), context.failure()});
            }
        });
        this.loggerHandler.handle((Object)context);
    }

    public LoggerHandler customFormatter(Function<HttpServerRequest, String> formatter) {
        return this.loggerHandler.customFormatter(formatter);
    }

    public LoggerHandler customFormatter(LoggerFormatter formatter) {
        return this.loggerHandler.customFormatter(formatter);
    }

    private Object toJson(MultiMap params) {
        if (params == null) {
            return "";
        }
        return Json.encode((Object)params.entries());
    }
}

