/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.modules.ApiModule;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

public class GossipHealthHandler
extends AbstractHandler<Void> {
    @Inject
    protected GossipHealthHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, null);
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Void request) {
        StorageOperations operations = this.metadataFetcher.delegate(host).storageOperations();
        this.executorPools.service().executeBlocking(() -> ((StorageOperations)operations).isGossipRunning()).onSuccess(isGossipRunning -> context.json(isGossipRunning != false ? ApiModule.OK_STATUS : ApiModule.NOT_OK_STATUS)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }

    @Override
    protected Void extractParamsOrThrow(RoutingContext context) {
        return null;
    }
}

