/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.vertx.core.http.HttpMethod;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaReportingConfiguration;
import org.apache.cassandra.sidecar.config.yaml.PeriodicTaskConfigurationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaReportingConfigurationImpl
extends PeriodicTaskConfigurationImpl
implements SchemaReportingConfiguration {
    protected static final boolean DEFAULT_ENABLED = false;
    protected static final MillisecondBoundConfiguration DEFAULT_INITIAL_DELAY = new MillisecondBoundConfiguration(6L, TimeUnit.HOURS);
    protected static final MillisecondBoundConfiguration DEFAULT_EXECUTE_INTERVAL = new MillisecondBoundConfiguration(12L, TimeUnit.HOURS);
    protected static final String DEFAULT_ENDPOINT = null;
    protected static final String DEFAULT_METHOD = HttpMethod.PUT.name();
    protected static final int DEFAULT_MAX_RETRIES = 3;
    protected static final MillisecondBoundConfiguration DEFAULT_RETRY_DELAY = new MillisecondBoundConfiguration(1L, TimeUnit.MINUTES);
    @JsonProperty(value="endpoint")
    @Nullable
    protected final String endpoint;
    @JsonProperty(value="method")
    @NotNull
    protected final String method;
    @JsonProperty(value="max_retries")
    protected final int maxRetries;
    @JsonProperty(value="retry_delay")
    @NotNull
    protected final MillisecondBoundConfiguration retryDelay;

    public SchemaReportingConfigurationImpl() {
        this(false, DEFAULT_INITIAL_DELAY, DEFAULT_EXECUTE_INTERVAL, DEFAULT_ENDPOINT, DEFAULT_METHOD, 3, DEFAULT_RETRY_DELAY);
    }

    public SchemaReportingConfigurationImpl(boolean enabled, @NotNull MillisecondBoundConfiguration initialDelay, @NotNull MillisecondBoundConfiguration executeInterval, @Nullable String endpoint, @NotNull String method, int maxRetries, @NotNull MillisecondBoundConfiguration retryDelay) {
        super(enabled, initialDelay, executeInterval);
        this.endpoint = endpoint;
        this.method = method;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
    }

    @Override
    @Nullable
    public String endpoint() {
        return this.endpoint;
    }

    @Override
    @NotNull
    public HttpMethod method() {
        return HttpMethod.valueOf((String)this.method);
    }

    @Override
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    @NotNull
    public MillisecondBoundConfiguration retryDelay() {
        return this.retryDelay;
    }
}

