/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.cassandra.sidecar.config.S3ProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ProxyConfigurationImpl
implements S3ProxyConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ProxyConfigurationImpl.class);
    @JsonProperty(value="proxy")
    protected final String proxy;
    @JsonProperty(value="username")
    protected final String username;
    @JsonProperty(value="password")
    protected final String password;
    @JsonProperty(value="endpoint_override")
    protected final String endpointOverride;

    protected S3ProxyConfigurationImpl() {
        this(null, null, null, null);
    }

    protected S3ProxyConfigurationImpl(String proxy, String username, String password, String endpointOverride) {
        this.proxy = proxy;
        this.username = username;
        this.password = password;
        this.endpointOverride = endpointOverride;
    }

    @Override
    @JsonProperty(value="proxy")
    public URI proxy() {
        return this.toURI(this.proxy, "S3 client proxy");
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public String password() {
        return this.password;
    }

    @Override
    @JsonProperty(value="endpoint_override")
    @VisibleForTesting
    public URI endpointOverride() {
        return this.toURI(this.endpointOverride, "S3 client endpointOverrides");
    }

    private URI toURI(String uriString, String hint) {
        if (uriString == null) {
            return null;
        }
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            LOGGER.error("{} is specified, but the value is invalid. input={}", (Object)hint, (Object)uriString);
            throw new RuntimeException("Unable to resolve " + uriString, e);
        }
    }
}

