/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cassandra.spark.transports.storage.extensions;

import org.apache.spark.SparkConf;

/**
 * Extension methods that are invoked in both Spark driver and executors
 * Package-private interface only to be extended by {@link StorageTransportExtension}
 */
interface CommonStorageTransportExtension
{
    /**
     * Initializes the instance of this class after it has been created.
     * The initialization implementation could differentiate based on whether is it running on Spark driver or executor
     *
     * @param jobId the unique identifier for the job.
     *              It could either be supplied by customer with {@link org.apache.cassandra.spark.bulkwriter.WriterOptions#JOB_ID},
     *              or a unique id string generated by the job on starting up, if no jobId is supplied.
     * @param conf the spark configuration
     * @param isOnDriver indicate whether the role of the runtime is Spark driver or executor
     */
    void initialize(String jobId, SparkConf conf, boolean isOnDriver);

    /**
     * Returns the {@link StorageTransportConfiguration}
     *
     * @return the {@link StorageTransportConfiguration}
     */
    StorageTransportConfiguration getStorageConfiguration();
}
