/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.v1;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.paxos.v1.AbstractPaxosCallback;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.Nemesis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposeCallback
extends AbstractPaxosCallback<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(ProposeCallback.class);
    @Nemesis
    private final AtomicInteger accepts = new AtomicInteger(0);
    private final int requiredAccepts;
    private final boolean failFast;

    public ProposeCallback(int totalTargets, int requiredTargets, boolean failFast, ConsistencyLevel consistency, Dispatcher.RequestTime requestTime) {
        super(totalTargets, consistency, requestTime);
        this.requiredAccepts = requiredTargets;
        this.failFast = failFast;
    }

    @Override
    public void onResponse(Message<Boolean> msg) {
        logger.trace("Propose response {} from {}", msg.payload, (Object)msg.from());
        if (((Boolean)msg.payload).booleanValue()) {
            this.accepts.incrementAndGet();
        }
        this.latch.decrement();
        if (this.isSuccessful() || this.failFast && this.latch.count() + this.accepts.get() < this.requiredAccepts) {
            while (this.latch.count() > 0) {
                this.latch.decrement();
            }
        }
    }

    public int getAcceptCount() {
        return this.accepts.get();
    }

    public boolean isSuccessful() {
        return this.accepts.get() >= this.requiredAccepts;
    }

    public boolean isFullyRefused() {
        return this.latch.count() == 0 && this.accepts.get() == 0;
    }
}

