/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import org.apache.cassandra.config.Config;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.TableMetadata;

public class DataComponent {
    public static SequentialWriter buildWriter(Descriptor descriptor, TableMetadata metadata, SequentialWriterOption options, MetadataCollector metadataCollector, OperationType operationType, Config.FlushCompression flushCompression) {
        if (metadata.params.compression.isEnabled()) {
            CompressionParams compressionParams = DataComponent.buildCompressionParams(metadata, operationType, flushCompression);
            return new CompressedSequentialWriter(descriptor.fileFor(SSTableFormat.Components.DATA), descriptor.fileFor(SSTableFormat.Components.COMPRESSION_INFO), descriptor.fileFor(SSTableFormat.Components.DIGEST), options, compressionParams, metadataCollector);
        }
        return new ChecksummedSequentialWriter(descriptor.fileFor(SSTableFormat.Components.DATA), descriptor.fileFor(SSTableFormat.Components.CRC), descriptor.fileFor(SSTableFormat.Components.DIGEST), options);
    }

    private static CompressionParams buildCompressionParams(TableMetadata metadata, OperationType operationType, Config.FlushCompression flushCompression) {
        CompressionParams compressionParams = metadata.params.compression;
        ICompressor compressor = compressionParams.getSstableCompressor();
        if (null != compressor && operationType == OperationType.FLUSH) {
            switch (flushCompression) {
                case none: {
                    compressionParams = CompressionParams.NOOP;
                    break;
                }
                case fast: {
                    if (compressor.recommendedUses().contains((Object)ICompressor.Uses.FAST_COMPRESSION)) break;
                    compressionParams = CompressionParams.DEFAULT;
                    break;
                }
            }
        }
        return compressionParams;
    }
}

