/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.memtable.TrieMemtable;
import org.apache.cassandra.db.tries.InMemoryTrie;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.memory.FilteringInMemoryKeyRangeIterator;
import org.apache.cassandra.index.sai.memory.InMemoryKeyRangeIterator;
import org.apache.cassandra.index.sai.memory.MemoryIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.index.sai.utils.PrimaryKeys;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrieMemoryIndex
extends MemoryIndex {
    private static final Logger logger = LoggerFactory.getLogger(TrieMemoryIndex.class);
    private static final int MAX_RECURSIVE_KEY_LENGTH = 128;
    private static final int MINIMUM_PRIORITY_QUEUE_SIZE = 128;
    private final InMemoryTrie<PrimaryKeys> data;
    private final PrimaryKeysReducer primaryKeysReducer;
    private ByteBuffer minTerm;
    private ByteBuffer maxTerm;
    private final AtomicInteger lastPriorityQueueSize = new AtomicInteger(128);

    public TrieMemoryIndex(StorageAttachedIndex index) {
        super(index);
        this.data = new InMemoryTrie(TrieMemtable.BUFFER_TYPE);
        this.primaryKeysReducer = new PrimaryKeysReducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long add(DecoratedKey key, Clustering<?> clustering, ByteBuffer value) {
        value = this.index.termType().asIndexBytes(value);
        PrimaryKey primaryKey = this.index.hasClustering() ? this.index.keyFactory().create(key, clustering) : this.index.keyFactory().create(key);
        long initialSizeOnHeap = this.data.sizeOnHeap();
        long initialSizeOffHeap = this.data.sizeOffHeap();
        long reducerHeapSize = this.primaryKeysReducer.heapAllocations();
        if (this.index.hasAnalyzer()) {
            AbstractAnalyzer analyzer = this.index.analyzer();
            try {
                analyzer.reset(value);
                while (analyzer.hasNext()) {
                    this.addTerm(primaryKey, analyzer.next());
                }
            }
            finally {
                analyzer.end();
            }
        } else {
            this.addTerm(primaryKey, value);
        }
        long onHeap = this.data.sizeOnHeap();
        long offHeap = this.data.sizeOffHeap();
        long heapAllocations = this.primaryKeysReducer.heapAllocations();
        return onHeap - initialSizeOnHeap + (offHeap - initialSizeOffHeap) + (heapAllocations - reducerHeapSize);
    }

    @Override
    public long update(DecoratedKey key, Clustering<?> clustering, ByteBuffer oldValue, ByteBuffer newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyRangeIterator search(QueryContext queryContext, Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        if (logger.isTraceEnabled()) {
            logger.trace("Searching memtable index on expression '{}'...", (Object)expression);
        }
        switch (expression.getIndexOperator()) {
            case EQ: 
            case CONTAINS_KEY: 
            case CONTAINS_VALUE: {
                return this.exactMatch(expression, keyRange);
            }
            case RANGE: {
                KeyRangeIterator keyIterator = this.rangeMatch(expression, keyRange);
                int keyCount = (int)keyIterator.getMaxKeys();
                if (keyCount > 128) {
                    this.lastPriorityQueueSize.set(keyCount);
                }
                return keyIterator;
            }
        }
        throw new IllegalArgumentException("Unsupported expression: " + expression);
    }

    @Override
    public Iterator<Pair<ByteComparable, PrimaryKeys>> iterator() {
        final Iterator iterator = this.data.entrySet().iterator();
        return new Iterator<Pair<ByteComparable, PrimaryKeys>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Pair<ByteComparable, PrimaryKeys> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                return Pair.create((ByteComparable)entry.getKey(), (PrimaryKeys)entry.getValue());
            }
        };
    }

    @Override
    public SegmentMetadata.ComponentMetadataMap writeDirect(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier, Function<PrimaryKey, Integer> postingTransformer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.minTerm == null;
    }

    @Override
    public ByteBuffer getMinTerm() {
        return this.minTerm;
    }

    @Override
    public ByteBuffer getMaxTerm() {
        return this.maxTerm;
    }

    private void addTerm(PrimaryKey primaryKey, ByteBuffer term) {
        if (this.index.validateTermSize(primaryKey.partitionKey(), term, false, null)) {
            this.setMinMaxTerm(term.duplicate());
            ByteComparable comparableBytes = this.asComparableBytes(term);
            try {
                if (term.limit() <= 128) {
                    this.data.putRecursive(comparableBytes, primaryKey, this.primaryKeysReducer);
                } else {
                    this.data.apply(Trie.singleton(comparableBytes, primaryKey), this.primaryKeysReducer);
                }
            }
            catch (InMemoryTrie.SpaceExhaustedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setMinMaxTerm(ByteBuffer term) {
        assert (term != null);
        this.minTerm = this.index.termType().min(term, this.minTerm);
        this.maxTerm = this.index.termType().max(term, this.maxTerm);
    }

    private ByteComparable asComparableBytes(ByteBuffer input) {
        return version -> this.index.termType().asComparableBytes(input, version);
    }

    private KeyRangeIterator exactMatch(Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        ByteComparable comparableMatch = expression.lower() == null ? ByteComparable.EMPTY : this.asComparableBytes(expression.lower().value.encoded);
        PrimaryKeys primaryKeys = (PrimaryKeys)this.data.get(comparableMatch);
        return primaryKeys == null ? KeyRangeIterator.empty() : new FilteringInMemoryKeyRangeIterator(primaryKeys.keys(), keyRange);
    }

    private KeyRangeIterator rangeMatch(Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        boolean upperInclusive;
        ByteComparable upperBound;
        boolean lowerInclusive;
        ByteComparable lowerBound;
        if (expression.lower() != null) {
            lowerBound = this.asComparableBytes(expression.lower().value.encoded);
            lowerInclusive = expression.lower().inclusive;
        } else {
            lowerBound = ByteComparable.EMPTY;
            lowerInclusive = false;
        }
        if (expression.upper() != null) {
            upperBound = this.asComparableBytes(expression.upper().value.encoded);
            upperInclusive = expression.upper().inclusive;
        } else {
            upperBound = null;
            upperInclusive = false;
        }
        Collector cd = new Collector(keyRange, this.lastPriorityQueueSize.get());
        Iterator values = this.data.subtrie(lowerBound, lowerInclusive, upperBound, upperInclusive).valueIterator();
        while (values.hasNext()) {
            cd.processContent((PrimaryKeys)values.next());
        }
        if (cd.mergedKeys.isEmpty()) {
            return KeyRangeIterator.empty();
        }
        return new InMemoryKeyRangeIterator(cd.mergedKeys.peek(), cd.maximumKey, cd.mergedKeys);
    }

    private static class PrimaryKeysReducer
    implements InMemoryTrie.UpsertTransformer<PrimaryKeys, PrimaryKey> {
        private final LongAdder heapAllocations = new LongAdder();

        private PrimaryKeysReducer() {
        }

        @Override
        public PrimaryKeys apply(PrimaryKeys existing, PrimaryKey neww) {
            if (existing == null) {
                existing = new PrimaryKeys();
                this.heapAllocations.add(existing.unsharedHeapSize());
            }
            this.heapAllocations.add(existing.add(neww));
            return existing;
        }

        long heapAllocations() {
            return this.heapAllocations.longValue();
        }
    }

    private static class Collector {
        final PriorityQueue<PrimaryKey> mergedKeys;
        final AbstractBounds<PartitionPosition> keyRange;
        PrimaryKey maximumKey = null;

        public Collector(AbstractBounds<PartitionPosition> keyRange, int expectedKeys) {
            this.keyRange = keyRange;
            this.mergedKeys = new PriorityQueue(expectedKeys);
        }

        public void processContent(PrimaryKeys keys) {
            if (keys.isEmpty()) {
                return;
            }
            SortedSet<PrimaryKey> primaryKeys = keys.keys();
            if (primaryKeys.size() == 1) {
                this.processKey(primaryKeys.first());
                return;
            }
            if (!((PartitionPosition)this.keyRange.right).isMinimum() && primaryKeys.first().partitionKey().compareTo((PartitionPosition)this.keyRange.right) > 0 || primaryKeys.last().partitionKey().compareTo((PartitionPosition)this.keyRange.left) < 0) {
                return;
            }
            for (PrimaryKey primaryKey : primaryKeys) {
                this.processKey(primaryKey);
            }
        }

        private void processKey(PrimaryKey key) {
            if (this.keyRange.contains(key.partitionKey())) {
                this.mergedKeys.add(key);
                this.maximumKey = this.maximumKey == null ? key : (key.compareTo(this.maximumKey) > 0 ? key : this.maximumKey);
            }
        }
    }
}

