/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.masking;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.masking.MaskingFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class HashMaskingFunction
extends MaskingFunction {
    public static final String NAME = "hash";
    public static final ByteBuffer DEFAULT_ALGORITHM = UTF8Type.instance.decompose("SHA-256");
    private static final Map<ByteBuffer, MessageDigest> DIGESTS = new ConcurrentHashMap<ByteBuffer, MessageDigest>();
    private static final AbstractType<?>[] DEFAULT_ARGUMENTS = new AbstractType[0];
    private static final AbstractType<?>[] ARGUMENTS_WITH_ALGORITHM = new AbstractType[]{UTF8Type.instance};

    private HashMaskingFunction(FunctionName name, AbstractType<?> inputType, boolean hasAlgorithmArgument) {
        super(name, BytesType.instance, inputType, hasAlgorithmArgument ? ARGUMENTS_WITH_ALGORITHM : DEFAULT_ARGUMENTS);
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return new FunctionArguments(version, ArgumentDeserializer.NOOP_DESERIALIZER, (v, b) -> HashMaskingFunction.messageDigest(b));
    }

    @Override
    public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
        ByteBuffer value = (ByteBuffer)arguments.get(0);
        if (value == null) {
            return null;
        }
        MessageDigest digest = (MessageDigest)arguments.get(1);
        if (digest == null) {
            digest = HashMaskingFunction.messageDigest(DEFAULT_ALGORITHM);
        }
        return HashMaskingFunction.hash(digest, value);
    }

    @Nullable
    @VisibleForTesting
    static ByteBuffer hash(MessageDigest digest, ByteBuffer value) {
        if (value == null) {
            return null;
        }
        byte[] hash = digest.digest(ByteBufferUtil.getArray(value));
        return (ByteBuffer)BytesType.instance.compose(ByteBuffer.wrap(hash));
    }

    @VisibleForTesting
    static MessageDigest messageDigest(@Nullable ByteBuffer algorithm) {
        ByteBuffer cacheKey = algorithm == null ? DEFAULT_ALGORITHM : algorithm;
        MessageDigest digest = DIGESTS.get(cacheKey);
        if (digest == null) {
            digest = HashMaskingFunction.messageDigest((String)UTF8Type.instance.compose(cacheKey));
            DIGESTS.put(cacheKey.duplicate(), digest);
        }
        return digest;
    }

    @VisibleForTesting
    static MessageDigest messageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidRequestException("Hash algorithm not found: " + algorithm);
        }
    }

    public static FunctionFactory factory() {
        return new MaskingFunction.Factory(NAME, new FunctionParameter[]{FunctionParameter.anyType(false), FunctionParameter.optional(FunctionParameter.fixed(CQL3Type.Native.TEXT))}){

            @Override
            protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
                switch (argTypes.size()) {
                    case 1: {
                        return new HashMaskingFunction(this.name, argTypes.get(0), false);
                    }
                    case 2: {
                        return new HashMaskingFunction(this.name, argTypes.get(0), true);
                    }
                }
                throw this.invalidNumberOfArgumentsException();
            }
        };
    }
}

